/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import logic.LogicComponent;
import logic.Pin;

public class BoolsToInt
extends AbstractLogicComponent {
    public BoolsToInt(int numLines) {
        super(numLines, 1);
        this.out[0].setIsInt();
        this.out[0].setNumOfLines(numLines);
    }

    public BoolsToInt(LogicComponent component, int start, int end, boolean inc) {
        super(end + 1 - start, 1);
        this.out[0].setIsInt();
        this.out[0].setNumOfLines(end + 1 - start);
        int i = 0;
        while (i < this.in.length) {
            Pin pin = null;
            pin = inc ? component.getOutPin(start + i) : component.getOutPin(end - i);
            this.setInPin(i, pin);
            ++i;
        }
    }

    @Override
    public void func() {
        int val = 0;
        int i = 0;
        while (i < this.in.length) {
            if (this.in[i].getBoolVal()) {
                val += 1 << i;
            }
            ++i;
        }
        this.out[0].setIntVal(val);
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }
}

