/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import java.util.Arrays;
import java.util.HashSet;
import logic.AbstractLogicComponent;
import logic.Execution;
import logic.Pin;
import util.Log;

public class BUS
extends AbstractLogicComponent {
    public BUS(String name) {
        super(0, 1, name, 0);
        this.out[0].setIsInt();
        this.out[0].setName(name);
        Execution.addSequentialComponent(new BusWatcher(this));
    }

    @Override
    public void func() {
        int activeInput = 0;
        HashSet<Integer> vals = new HashSet<Integer>();
        int i = 0;
        while (i < this.in.length) {
            if (this.in[i].isDriver()) {
                activeInput = i;
                if (this.out[0].isBool()) {
                    vals.add(this.in[i].getBoolVal() ? 0 : 1);
                } else {
                    vals.add(this.in[i].getIntVal());
                }
            }
            ++i;
        }
        if (vals.size() > 1) {
            Log.errorDialog(":Warning!!! Bus " + this.name + " may be burned!");
            return;
        }
        if (vals.size() == 0) {
            this.out[0].setHighZ(true);
            i = 0;
            while (i < this.in.length) {
                this.in[i].setHighZ(true);
                ++i;
            }
        }
        if (vals.size() == 1) {
            this.out[0].setHighZ(false);
            if (this.out[0].isBool()) {
                this.out[0].setBoolVal(this.in[activeInput].getBoolVal());
            } else {
                this.out[0].setIntVal(this.in[activeInput].getIntVal());
            }
            i = 0;
            while (i < this.in.length) {
                if (this.in[i].isBool()) {
                    this.in[i].setBoolVal(this.in[activeInput].getBoolVal());
                } else {
                    this.in[i].setIntVal(this.in[activeInput].getIntVal());
                }
                ++i;
            }
        }
    }

    @Override
    public void setInPin(int index, Pin pin) {
        if (pin == null) {
            return;
        }
        this.in = Arrays.copyOf(this.in, this.in.length + 1);
        this.in[this.in.length - 1] = pin;
        pin.addChild(this);
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.name) + " " + this.out[0].toString();
        return result;
    }

    class BusWatcher
    extends AbstractLogicComponent {
        BUS bus;

        public BusWatcher(BUS bus) {
            super(0, 0);
            this.bus = bus;
        }

        @Override
        public void func() {
            int cnt = 0;
            int i = 0;
            while (i < this.bus.in.length) {
                if (this.bus.in[i].isDriver()) {
                    ++cnt;
                }
                ++i;
            }
            if (cnt > 1) {
                Log.errorDialog(":Error!!! Bus " + this.bus.name + " was burned!");
                return;
            }
        }

        @Override
        public void initArgs(String[] args) {
        }

        @Override
        public String toString() {
            String result = String.valueOf(this.bus.name) + " " + this.bus.out[0].toString();
            return result;
        }
    }
}

