/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import logic.Pin;
import util.Log;
import util.Mask;

public class ALU
extends AbstractLogicComponent {
    private Pin add;
    private Pin sub;
    private Pin inc;
    private Pin dec;
    private Pin and;
    private Pin or;
    private Pin xor;
    private Pin not;
    private Pin CN;
    private int size = 0;
    private int mask = 255;

    public ALU(int size) {
        super(2, 1);
        this.out[0].setIsInt();
        this.out[0].setNumOfLines(size);
        this.CN = new Pin(false, "CN");
        this.allPins.add(this.CN);
        this.checkSize(size);
    }

    public void checkSize(int size) {
        if (this.size > 32) {
            throw new RuntimeException("Maxima ALU size 32: " + this.size);
        }
        this.size = size;
        this.mask = Mask.createMask(size);
    }

    @Override
    public void func() {
        int akc = 0;
        if (this.add != null && this.add.getBoolVal()) {
            ++akc;
        }
        if (this.sub != null && this.sub.getBoolVal()) {
            ++akc;
        }
        if (this.inc != null && this.inc.getBoolVal()) {
            ++akc;
        }
        if (this.dec != null && this.dec.getBoolVal()) {
            ++akc;
        }
        if (this.and != null && this.and.getBoolVal()) {
            ++akc;
        }
        if (this.or != null && this.or.getBoolVal()) {
            ++akc;
        }
        if (this.xor != null && this.xor.getBoolVal()) {
            ++akc;
        }
        if (this.not != null && this.not.getBoolVal()) {
            ++akc;
        }
        if (akc > 1) {
            Log.errorDialog(":Error!!! Multiple ALU operations active");
            this.out[0].setIntVal(0);
            this.CN.setBoolVal(false);
            return;
        }
        if (akc == 0) {
            this.out[0].setIntVal(0);
            this.CN.setBoolVal(false);
            return;
        }
        int A = this.in[0].getIntVal();
        if (this.in[0].isHighZ()) {
            A = 0;
        }
        int B = this.in[1].getIntVal();
        if (this.in[1].isHighZ()) {
            B = 0;
        }
        if (this.add != null && this.add.getBoolVal()) {
            int result = A + B;
            this.out[0].setIntVal(result &= this.mask);
            if (this.CN != null) {
                long al = (long)A & 0xFFFFFFFFL;
                long bl = (long)B & 0xFFFFFFFFL;
                long maskl = (long)this.mask & 0xFFFFFFFFL;
                if (al + bl > maskl) {
                    this.CN.setBoolVal(true);
                } else {
                    this.CN.setBoolVal(false);
                }
            }
            return;
        }
        if (this.sub != null && this.sub.getBoolVal()) {
            int result = A - B;
            this.out[0].setIntVal(result &= this.mask);
            if (this.CN != null) {
                long al = (long)A & 0xFFFFFFFFL;
                long bl = (long)(~B) + 1L & (long)this.mask & 0xFFFFFFFFL;
                long maskl = (long)this.mask & 0xFFFFFFFFL;
                if (al + bl > maskl) {
                    this.CN.setBoolVal(true);
                } else {
                    this.CN.setBoolVal(false);
                }
            }
            return;
        }
        if (this.inc != null && this.inc.getBoolVal()) {
            int result = A + 1;
            this.out[0].setIntVal(result &= this.mask);
            if (this.CN != null) {
                long al = (long)A & 0xFFFFFFFFL;
                long bl = 1L;
                long maskl = (long)this.mask & 0xFFFFFFFFL;
                if (al + bl > maskl) {
                    this.CN.setBoolVal(true);
                } else {
                    this.CN.setBoolVal(false);
                }
            }
            return;
        }
        if (this.dec != null && this.dec.getBoolVal()) {
            int result = A - 1;
            this.out[0].setIntVal(result &= this.mask);
            if (this.CN != null) {
                long al = (long)A & 0xFFFFFFFFL;
                long bl = (long)this.mask & 0xFFFFFFFFL;
                long maskl = (long)this.mask & 0xFFFFFFFFL;
                if (al + bl > maskl) {
                    this.CN.setBoolVal(true);
                } else {
                    this.CN.setBoolVal(false);
                }
            }
            return;
        }
        if (this.and != null && this.and.getBoolVal()) {
            int result = A & B;
            this.out[0].setIntVal(result &= this.mask);
            this.CN.setBoolVal(false);
            return;
        }
        if (this.or != null && this.or.getBoolVal()) {
            int result = A | B;
            this.out[0].setIntVal(result &= this.mask);
            this.CN.setBoolVal(false);
            return;
        }
        if (this.xor != null && this.xor.getBoolVal()) {
            int result = A ^ B;
            this.out[0].setIntVal(result &= this.mask);
            this.CN.setBoolVal(false);
            return;
        }
        if (this.not != null && this.not.getBoolVal()) {
            int result = ~A;
            this.out[0].setIntVal(result &= this.mask);
            this.CN.setBoolVal(false);
            return;
        }
    }

    public void setPinX(Pin pin) {
        this.setInPin(0, pin);
    }

    public void setPinY(Pin pin) {
        this.setInPin(1, pin);
    }

    public void setPinAdd(Pin add) {
        this.add = add;
        add.addChild(this);
    }

    public void setPinSub(Pin sub) {
        this.sub = sub;
        sub.addChild(this);
    }

    public void setPinInc(Pin inc) {
        this.inc = inc;
        inc.addChild(this);
    }

    public void setPinDec(Pin dec) {
        this.dec = dec;
        dec.addChild(this);
    }

    public void setPinAnd(Pin and) {
        this.and = and;
        and.addChild(this);
    }

    public void setPinOr(Pin or) {
        this.or = or;
        or.addChild(this);
    }

    public void setPinXor(Pin xor) {
        this.xor = xor;
        xor.addChild(this);
    }

    public void setPinNot(Pin not) {
        this.not = not;
        not.addChild(this);
    }

    public Pin getPinC_Last() {
        return this.CN;
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }
}

