/*
 * Decompiled with CFR 0.152.
 */
package logic;

import java.util.ArrayList;
import java.util.List;
import logic.LogicComponent;

public class Pin {
    private String name;
    private boolean isBool;
    private int numOfLines;
    private int mask;
    private boolean boolVal;
    private int intVal;
    private boolean highZ;
    private boolean driver;
    private List<LogicComponent> children;

    public Pin(String name) {
        this(name, true, 1, 0, false, false);
    }

    public Pin(boolean val, String name) {
        this(name, true, 1, 0, val, false);
    }

    public Pin(int val, int brlin, String name) {
        this(name, false, brlin, val, false, false);
    }

    public Pin(String name, boolean isBool, int numOfLines, int intVal, boolean boolVal, boolean highZ) {
        this.name = name;
        this.isBool = isBool;
        this.numOfLines = numOfLines;
        this.mask = (int)((1L << numOfLines) - 1L);
        this.intVal = intVal;
        this.boolVal = boolVal;
        this.highZ = highZ;
        this.driver = !highZ;
        this.children = new ArrayList<LogicComponent>();
    }

    public boolean isBool() {
        return this.isBool;
    }

    public void setIsInt() {
        this.isBool = false;
    }

    public void setIsBool() {
        this.isBool = true;
    }

    public void clear() {
        if (this.boolVal || this.intVal != 0) {
            this.boolVal = false;
            this.intVal = 0;
            this.signalAll();
        }
    }

    public boolean getBoolVal() {
        return this.boolVal;
    }

    public void setBoolVal(boolean bVal) {
        if (this.isBool && (this.boolVal != bVal || this.highZ)) {
            this.boolVal = bVal;
            this.highZ = false;
            if (this.driver) {
                this.signalAll();
            }
        }
    }

    public int getIntVal() {
        return this.intVal;
    }

    public void setIntVal(int iVal) {
        iVal = this.mask & iVal;
        if (!this.isBool && (this.intVal != iVal || this.highZ)) {
            this.intVal = iVal;
            this.highZ = false;
            if (this.driver) {
                this.signalAll();
            }
        }
    }

    public boolean isHighZ() {
        return this.highZ;
    }

    public boolean isDriver() {
        return this.driver;
    }

    public void setHighZ(boolean highZboolValue) {
        if (this.highZ != highZboolValue) {
            this.highZ = highZboolValue;
            this.driver = !highZboolValue;
            this.signalAll();
        }
    }

    public void setVal(Pin pin) {
        if (this.boolVal != pin.boolVal || this.intVal != pin.intVal || this.highZ) {
            this.boolVal = pin.boolVal;
            this.intVal = pin.intVal;
            this.highZ = pin.highZ;
            this.signalAll();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumOfLines() {
        return this.numOfLines;
    }

    public void setNumOfLines(int numOfLines) {
        if (numOfLines < 0 || numOfLines > 32) {
            throw new RuntimeException("Not suppotres port size greater then 32:" + numOfLines);
        }
        this.numOfLines = numOfLines;
        this.mask = (int)((1L << numOfLines) - 1L);
    }

    public void addChild(LogicComponent logcomp) {
        if (!this.children.contains(logcomp)) {
            this.children.add(logcomp);
        }
    }

    public List<LogicComponent> getChildren() {
        return this.children;
    }

    void signalAll() {
        LogicComponent child = null;
        int i = 0;
        while (i < this.children.size()) {
            child = this.children.get(i);
            if (!child.isSeq()) {
                child.execute();
            }
            ++i;
        }
    }

    public boolean compare(Pin pin) {
        boolean result = pin != null && this.intVal == pin.intVal && this.boolVal == pin.boolVal && this.highZ == pin.highZ;
        return result;
    }

    public void copyVal(Pin pin) {
        if (pin == null) {
            return;
        }
        this.intVal = pin.intVal;
        this.boolVal = pin.boolVal;
        this.highZ = pin.highZ;
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.boolVal + ";" + this.intVal + ";" + this.highZ;
    }
}

