/*
 * Decompiled with CFR 0.152.
 */
package logic;

import java.util.Set;
import logic.AbstractLogicComponent;
import logic.LogicComponent;
import logic.components.AND;
import logic.components.DC;
import logic.components.IntToBools;
import logic.components.NAND;
import logic.components.NOR;
import logic.components.NOT;
import logic.components.OR;
import logic.components.TSB;
import logic.components.XOR;

public class LogicComponentFactory {
    public static LogicComponent loadComponent(String[] data, Set<String> supportedComponents) {
        AbstractLogicComponent result = null;
        try {
            String type = data[0];
            String name = data[1];
            if (supportedComponents == null || supportedComponents.contains(type)) {
                int size = Integer.parseInt(data[2]);
                if (type.equalsIgnoreCase("OR")) {
                    result = new OR(size, name);
                    result.initArgs(data);
                } else if (type.equalsIgnoreCase("AND")) {
                    result = new AND(size, name);
                    result.initArgs(data);
                } else if (type.equalsIgnoreCase("NAND")) {
                    result = new NAND(size, name);
                    result.initArgs(data);
                } else if (type.equalsIgnoreCase("NOR")) {
                    result = new NOR(size, name);
                    result.initArgs(data);
                } else if (type.equalsIgnoreCase("XOR")) {
                    result = new XOR(size, name);
                    result.initArgs(data);
                } else if (type.equalsIgnoreCase("NOT")) {
                    result = new NOT(name);
                    result.initArgs(data);
                } else if (type.equalsIgnoreCase("SPLIT")) {
                    result = new IntToBools(size, name);
                    result.initArgs(data);
                } else if (type.equalsIgnoreCase("DC")) {
                    result = new DC(size);
                    result.initArgs(data);
                } else if (type.equalsIgnoreCase("TRI")) {
                    result = TSB.createTSB(data);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

