/*
 * Decompiled with CFR 0.152.
 */
package logic;

import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import util.Element;
import util.ValidationElement;

public abstract class AbstractLogicComponent
implements LogicComponent {
    protected String name;
    protected String[] args;
    protected Pin[] in;
    protected Pin[] out;
    protected List<Pin> allPins;
    protected int period;

    public AbstractLogicComponent(int in, int out, String name, int period) {
        this.name = name;
        this.args = null;
        this.in = new Pin[in];
        this.out = new Pin[out];
        this.allPins = new LinkedList<Pin>();
        this.period = period;
        int i = 0;
        while (i < out) {
            Pin pin;
            this.out[i] = pin = new Pin("");
            this.allPins.add(pin);
            ++i;
        }
    }

    public AbstractLogicComponent(int in, int out) {
        this(in, out, "", 0);
    }

    public abstract void func();

    @Override
    public void execute() {
        this.func();
    }

    @Override
    public void propagate() {
    }

    @Override
    public void init(boolean fullInit) {
        this.func();
    }

    @Override
    public abstract void initArgs(String[] var1);

    @Override
    public boolean isSeq() {
        return this.period > 0;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setPeriod(int period) {
        this.period = period;
    }

    @Override
    public int getPeriod() {
        return this.period;
    }

    @Override
    public void setInPins(Pin[] in) {
        this.in = in;
        int i = 0;
        while (i < in.length) {
            in[i].addChild(this);
            ++i;
        }
    }

    @Override
    public void setInPin(int index, Pin pin) {
        this.in[index] = pin;
        pin.addChild(this);
    }

    @Override
    public void setOutPin(int index, Pin pin) {
        this.out[index] = pin;
    }

    @Override
    public Pin[] getOutPins() {
        return this.out;
    }

    @Override
    public Pin[] getInPins() {
        return this.in;
    }

    @Override
    public Pin getOutPin(int index) {
        if (index >= 0 && index < this.out.length) {
            return this.out[index];
        }
        return new Pin(false, "");
    }

    @Override
    public Pin getInPin(int index) {
        if (index >= 0 && index < this.in.length) {
            return this.in[index];
        }
        return new Pin(false, "");
    }

    @Override
    public Pin getPin(String pinName) {
        Pin result = null;
        for (Pin pin : this.allPins) {
            if (!pinName.equalsIgnoreCase(pin.getName())) continue;
            return pin;
        }
        return result;
    }

    @Override
    public List<Pin> getAllOutPins() {
        return this.allPins;
    }

    public String toString() {
        String result = String.valueOf(this.name) + "[" + this.in.length + ", " + this.out.length + "]";
        return result;
    }

    @Override
    public List<LogicComponent> getComponents() {
        LinkedList<LogicComponent> result = new LinkedList<LogicComponent>();
        return result;
    }

    @Override
    public void setComponents(List<LogicComponent> components) {
        throw new RuntimeException("Unsuported method: setComponents");
    }

    @Override
    public LogicComponent getComponent(String name) {
        return null;
    }

    @Override
    public void addComponent(String name, LogicComponent component) {
        throw new RuntimeException("Unsuported method: addComponent");
    }

    @Override
    public List<Element<String[], ValidationElement>> validateComponent(String[] data) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        return result;
    }

    @Override
    public List<Element<String[], ValidationElement>> validateConnection(String[] data) {
        LinkedList<Element<String[], ValidationElement>> result = new LinkedList<Element<String[], ValidationElement>>();
        return result;
    }
}

