/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logic.Execution;
import logic.LogicComponent;
import logic.components.FF;
import logic.components.MEM;
import logic.components.REG;
import util.Log;

public class Loader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadAll(String fileName) {
        LinkedList<String> memory = new LinkedList<String>();
        LinkedList<String> sequential = new LinkedList<String>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        Loader.setMemoryState(memory);
                        Loader.setSequentialState(sequential);
                        return;
                    }
                    try {
                        if (Loader.isEmpty(line = Loader.removeComments(line))) continue;
                        if (Loader.isSequentialLine(line)) {
                            sequential.add(line);
                            continue;
                        }
                        if (!Loader.isMemoryLine(line)) continue;
                        memory.add(line);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            Log.errorLog(e, "Init from file " + fileName);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void storeAll(String fileName) {
        List<String> memory = Loader.getMemoryState();
        List<String> sequential = Loader.getSequentialState();
        StringBuffer sb = new StringBuffer();
        for (String string : memory) {
            sb = sb.append(string).append("\n");
        }
        for (String string : sequential) {
            sb = sb.append(string).append("\n");
        }
        try {
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (PrintWriter writer = new PrintWriter(new FileWriter(fileName));){
                writer.print(sb.toString());
            }
            catch (Throwable throwable2) {
                void var4_12;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var4_12;
            }
        }
        catch (Exception exception) {
            Log.errorLog(exception, "Init from file " + fileName);
        }
    }

    private static void setSequentialState(List<String> sequential) {
        Map<String, LogicComponent> components = Loader.getComponents();
        for (String line : sequential) {
            try {
                String[] data = line.split(",");
                String name = data[0];
                int val = Integer.parseInt(data[1].trim(), 16);
                LogicComponent comp = components.get(name);
                if (!Loader.testValue(val, comp)) continue;
                if (comp instanceof REG) {
                    ((REG)comp).setVal(val);
                    continue;
                }
                if (!(comp instanceof FF)) continue;
                ((FF)comp).setState(val);
            }
            catch (Exception e) {
                Log.errorLog(e, "Error in line " + line);
            }
        }
    }

    private static List<String> getSequentialState() {
        LinkedList<String> sequential = new LinkedList<String>();
        Map<String, LogicComponent> components = Loader.getComponents();
        LinkedList<String> names = new LinkedList<String>(components.keySet());
        Collections.sort(names);
        for (String name : names) {
            String line;
            LogicComponent comp = components.get(name);
            int val = 0;
            if (comp instanceof REG) {
                val = ((REG)comp).getVal();
                line = String.valueOf(name) + ", " + Integer.toHexString(val);
                sequential.add(line);
                continue;
            }
            if (!(comp instanceof FF)) continue;
            val = ((FF)comp).getState();
            line = String.valueOf(name) + ", " + Integer.toHexString(val);
            sequential.add(line);
        }
        return sequential;
    }

    protected static boolean testValue(int val, LogicComponent comp) {
        int validBits = comp.getOutPin(0).isBool() ? comp.getOutPins().length : comp.getOutPin(0).getNumOfLines();
        boolean result = (int)Math.pow(2.0, validBits) > val;
        return result;
    }

    private static void setMemoryState(List<String> memory) {
        MEM mem = Loader.getMemory();
        for (String line : memory) {
            mem.setLine(line);
        }
    }

    private static MEM getMemory() {
        MEM mem = null;
        Map<String, LogicComponent> components = Loader.getComponents();
        for (LogicComponent comp : components.values()) {
            if (!(comp instanceof MEM)) continue;
            mem = (MEM)comp;
        }
        return mem;
    }

    private static List<String> getMemoryState() {
        MEM mem = Loader.getMemory();
        LinkedList<String> result = new LinkedList<String>();
        Map<Integer, String> memory = mem.getMemory();
        LinkedList<Integer> addresses = new LinkedList<Integer>(memory.keySet());
        Collections.sort(addresses);
        for (Integer adr : addresses) {
            String val = memory.get(adr);
            String line = String.valueOf(Integer.toHexString(adr)) + ", " + val;
            result.add(line);
        }
        return result;
    }

    private static boolean isEmpty(String line) {
        return false;
    }

    private static boolean isSequentialLine(String line) {
        String[] data = line.split(",");
        return data.length == 2 && Loader.isName(data[0]) && Loader.isInteger(data[1]);
    }

    private static boolean isName(String text) {
        boolean result = true;
        try {
            result = text.matches("[a-zA-Z]+\\w+");
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private static boolean isInteger(String text) {
        boolean result = true;
        try {
            int n = Integer.parseInt(text.trim(), 16);
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    private static boolean isMemoryLine(String line) {
        String[] data = line.split(",");
        return data.length == 2 && Loader.isInteger(data[0]) && Loader.isInteger(data[1]);
    }

    public static String removeComments(String line) {
        if (line != null) {
            int index = line.indexOf("//");
            if (index > 0) {
                line = line.substring(0, index);
                line = line.trim();
            }
            line = line.replace("\"", " ").trim();
        }
        return line;
    }

    public static Map<String, LogicComponent> getComponents() {
        HashSet<LogicComponent> resultSet = new HashSet<LogicComponent>();
        List<LogicComponent> comps = Execution.getComponent();
        for (LogicComponent comp : comps) {
            resultSet.add(comp);
        }
        HashMap<String, LogicComponent> result = new HashMap<String, LogicComponent>();
        for (LogicComponent component : resultSet) {
            String name = component.getName();
            if (name == null || name.equals("")) {
                name = String.valueOf(component.getClass().getSimpleName()) + "@" + component.hashCode();
            }
            result.put(name, component);
        }
        return result;
    }

    public static void loadMemory(String fileName) {
        MEM mem = Loader.getMemory();
        mem.initFromFile(fileName);
    }

    /*
     * WARNING - void declaration
     */
    public static void storeMemory(String fileName) {
        List<String> memory = Loader.getMemoryState();
        StringBuffer sb = new StringBuffer();
        for (String string : memory) {
            sb = sb.append(string).append("\n");
        }
        try {
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (PrintWriter writer = new PrintWriter(new FileWriter(fileName));){
                writer.print(sb.toString());
            }
            catch (Throwable throwable2) {
                void var3_9;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var3_9;
            }
        }
        catch (Exception exception) {
            Log.errorLog(exception, "Store to file " + fileName);
        }
    }
}

