/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;

public class DrawUtils {
    public static final int ALIGNRIGHT = 0;
    public static final int ALIGNLEFT = 1;
    public static final int ALIGCENTER = 2;

    public static int moveString(int x, String text, int fontSize, String fontName, int fontStyle) {
        int result = x - DrawUtils.stringWidth(text, fontSize, fontName, fontStyle);
        return result;
    }

    public static int calcX(int x, String label, int alignment, int fontSize, String fontName, int fontStyle) {
        switch (alignment) {
            case 0: {
                return x;
            }
            case 1: {
                return DrawUtils.moveString(x, label, fontSize, fontName, fontStyle);
            }
            case 2: {
                return (DrawUtils.moveString(x, label, fontSize, fontName, fontStyle) + x) / 2;
            }
        }
        return x;
    }

    public static int stringWidth(String text, int fontSize, String fontName, int fontStyle) {
        Font f = new Font(fontName, fontStyle, fontSize);
        Rectangle2D r = f.getStringBounds(text, new FontRenderContext(null, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT));
        int result = (int)r.getWidth();
        return result;
    }

    public static int stringHeight(String text, int fontSize, String fontName, int fontStyle) {
        Font f = new Font(fontName, fontStyle, fontSize);
        Rectangle2D r = f.getStringBounds(text, new FontRenderContext(null, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT));
        int result = (int)r.getHeight();
        return result;
    }
}

