/*
 * Decompiled with CFR 0.152.
 */
package shemes.components;

import gui.GuiComponent;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;
import logic.components.AND;
import logic.components.IntToBools;
import logic.components.MEM;
import logic.components.NOT;
import logic.components.TSB;
import shemes.AbstractSchema;
import shemes.components.Bus1;
import util.Element;
import util.Messages;
import util.NameConnector;
import util.Parameters;

public class MemorijaOperaciona
extends AbstractSchema {
    public static final String DNAME = "Mem1";
    private TSB TSBRDB;
    private NOT NOTRDB;
    private AND ANDrdMEM;
    private IntToBools ABUSBits;
    private AND ANDselect;
    private NOT NOTselect;
    private TSB TSBWRB;
    private NOT NOTWRB;
    private AND ANDwrMEM;
    private MEM RAM;
    private TSB TSBMEMout;
    private TSB TSBFCB;
    private NOT NOTFCB;

    public MemorijaOperaciona() {
        this.componentName = DNAME;
        this.displayName = Messages.getString("MemorijaOperaciona.NAME");
        NameConnector.addSchema(this.componentName, this);
    }

    @Override
    public void initComponent() {
        this.TSBRDB = new TSB("RDB");
        this.TSBRDB.getOutPin(0).setNumOfLines(1);
        this.TSBRDB.getOutPin(0).setIsBool();
        this.NOTRDB = new NOT();
        this.ANDrdMEM = new AND();
        this.ABUSBits = new IntToBools(16);
        this.ANDselect = new AND(4);
        this.NOTselect = new NOT();
        this.TSBWRB = new TSB("WRB");
        this.TSBWRB.getOutPin(0).setNumOfLines(1);
        this.TSBWRB.getOutPin(0).setIsBool();
        this.NOTWRB = new NOT();
        this.ANDwrMEM = new AND();
        this.RAM = new MEM(Parameters.sizeMemAdr, Parameters.sizeMemData, "RAM63K");
        this.RAM.getOutPin(0).setIsInt();
        this.RAM.getOutPin(0).setNumOfLines(Parameters.sizeMemData);
        this.TSBMEMout = new TSB("MEMout");
        this.TSBMEMout.getOutPin(0).setNumOfLines(Parameters.sizeMemData);
        this.TSBFCB = new TSB("FCB");
        this.TSBFCB.getOutPin(0).setIsBool();
        this.NOTFCB = new NOT();
        this.putPins();
        this.putComponents();
        super.initComponent();
    }

    @Override
    public void initConections() {
        this.TSBRDB.setInPin(0, NameConnector.getPin("Bus1.NOTRDBUS"));
        this.TSBRDB.setE(new Pin(true, "1"));
        this.NOTRDB.setInPin(0, this.TSBRDB.getOutPin(0));
        this.ANDrdMEM.setInPin(0, this.NOTRDB.getOutPin(0));
        this.ANDrdMEM.setInPin(1, this.NOTselect.getOutPin(0));
        this.ABUSBits.setInPin(0, NameConnector.getPin("Bus1.ABUS"));
        this.ANDselect.setInPin(0, this.ABUSBits.getOutPin(12));
        this.ANDselect.setInPin(1, this.ABUSBits.getOutPin(13));
        this.ANDselect.setInPin(2, this.ABUSBits.getOutPin(14));
        this.ANDselect.setInPin(3, this.ABUSBits.getOutPin(15));
        this.NOTselect.setInPin(0, this.ANDselect.getOutPin(0));
        this.TSBWRB.setInPin(0, NameConnector.getPin("Bus1.NOTWRBUS"));
        this.TSBWRB.setE(new Pin(true, "1"));
        this.NOTWRB.setInPin(0, this.TSBWRB.getOutPin(0));
        this.ANDwrMEM.setInPin(0, this.NOTselect.getOutPin(0));
        this.ANDwrMEM.setInPin(1, this.NOTWRB.getOutPin(0));
        this.RAM.setRead(this.ANDrdMEM.getOutPin(0));
        this.RAM.setWrite(this.ANDwrMEM.getOutPin(0));
        this.RAM.setInPin(0, NameConnector.getPin("Bus1.ABUS"));
        this.RAM.setInPin(1, NameConnector.getPin("Bus1.DBUS"));
        this.TSBMEMout.setInPin(0, this.RAM.getOutPin(0));
        this.TSBMEMout.setE(NameConnector.getPin("Mem2.MEMout"));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnDBUS(this.TSBMEMout.getOutPin(0));
        this.TSBFCB.setInPin(0, new Pin(true, "1"));
        this.TSBFCB.setE(NameConnector.getPin("Mem2.fcMEM"));
        this.NOTFCB.setInPin(0, this.TSBFCB.getOutPin(0));
        ((Bus1)NameConnector.getSchema("Bus1")).addOnNOTFCBUS(this.NOTFCB.getOutPin(0));
    }

    @Override
    public void initGui() {
        this.gui = new GuiComponent("src/images/Mem1.png");
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(84, 142));
        points.add(new Point(103, 142));
        sections.add(points);
        GuiPinLine line = new GuiPinLine(sections, NameConnector.getPin("Bus1.NOTRDBUS"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(132, 142));
        points.add(new Point(162, 142));
        sections.add(points);
        line = new GuiPinLine(sections, this.NOTRDB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(87, 167));
        points.add(new Point(103, 167));
        sections.add(points);
        line = new GuiPinLine(sections, this.ABUSBits.getOutPin(12));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(87, 180));
        points.add(new Point(103, 180));
        sections.add(points);
        line = new GuiPinLine(sections, this.ABUSBits.getOutPin(13));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(87, 195));
        points.add(new Point(103, 195));
        sections.add(points);
        line = new GuiPinLine(sections, this.ABUSBits.getOutPin(14));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(87, 208));
        points.add(new Point(103, 208));
        sections.add(points);
        line = new GuiPinLine(sections, this.ABUSBits.getOutPin(15));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(131, 187));
        points.add(new Point(143, 187));
        points.add(new Point(143, 153));
        points.add(new Point(162, 153));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(143, 187));
        points.add(new Point(143, 254));
        points.add(new Point(162, 254));
        sections.add(points);
        line = new GuiPinLine(sections, this.NOTselect.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(83, 267));
        points.add(new Point(103, 267));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.NOTWRBUS"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(130, 266));
        points.add(new Point(162, 266));
        sections.add(points);
        line = new GuiPinLine(sections, this.NOTWRB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(184, 147));
        points.add(new Point(254, 147));
        points.add(new Point(254, 176));
        points.add(new Point(342, 176));
        sections.add(points);
        line = new GuiPinLine(sections, this.ANDrdMEM.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(184, 261));
        points.add(new Point(253, 261));
        points.add(new Point(253, 195));
        points.add(new Point(342, 195));
        sections.add(points);
        line = new GuiPinLine(sections, this.ANDwrMEM.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(147, 355));
        points.add(new Point(147, 365));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Mem2.fcMEM"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(191, 371));
        points.add(new Point(158, 371));
        sections.add(points);
        line = new GuiPinLine(sections, new Pin(true, "1"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(131, 371));
        points.add(new Point(111, 371));
        sections.add(points);
        line = new GuiPinLine(sections, this.NOTFCB.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(443, 68));
        points.add(new Point(443, 136));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.ABUS"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(616, 68));
        points.add(new Point(616, 380));
        sections.add(points);
        points = new ArrayList();
        points.add(new Point(615, 185));
        points.add(new Point(531, 185));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Bus1.DBUS"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(437, 233));
        points.add(new Point(437, 286));
        points.add(new Point(521, 286));
        sections.add(points);
        line = new GuiPinLine(sections, this.RAM.getOutPin(0));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(531, 301));
        points.add(new Point(531, 291));
        sections.add(points);
        line = new GuiPinLine(sections, NameConnector.getPin("Mem2.MEMout"));
        this.gui.addDrawable(line);
        sections = new ArrayList();
        points = new ArrayList();
        points.add(new Point(542, 286));
        points.add(new Point(615, 286));
        sections.add(points);
        line = new GuiPinLine(sections, this.TSBMEMout.getOutPin(0));
        this.gui.addDrawable(line);
        this.gui.addDrawable(new GuiPinLabel(449, 91, NameConnector.getPin("Bus1.ABUS")));
        this.gui.addDrawable(new GuiPinLabel(622, 91, NameConnector.getPin("Bus1.DBUS")));
        this.gui.addDrawable(new GuiPinLabel(447, 248, this.RAM.getOutPin(0)));
        this.gui.addDrawable(new GuiPinLabel(570, 181, NameConnector.getPin("Bus1.DBUS")));
        this.gui.addDrawable(new GuiPinLabel(570, 282, this.TSBMEMout.getOutPin(0)));
        this.gui.addDrawable(new GuiTextLabel(595, 133, "" + Parameters.sizeMemData, 14));
        this.gui.addDrawable(new GuiTextLabel(548, 201, "" + Parameters.sizeMemData, 14));
        this.gui.addDrawable(new GuiTextLabel(415, 249, "" + Parameters.sizeMemData, 14));
        this.gui.addDrawable(new GuiTextLabel(595, 93, Parameters.sizeMemData - 1 + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(510, 193, Parameters.sizeMemData - 1 + "..0", 10));
        this.gui.addDrawable(new GuiTextLabel(452, 232, Parameters.sizeMemData - 1 + "..0", 10));
    }

    @Override
    public List<Element<String, Pin>> getPins() {
        LinkedList<Element<String, Pin>> result = new LinkedList<Element<String, Pin>>();
        result.add(new Element<String, Pin>("rdMEM", this.ANDrdMEM.getOutPin(0)));
        result.add(new Element<String, Pin>("wrMEM", this.ANDwrMEM.getOutPin(0)));
        return result;
    }

    @Override
    public List<Element<String, LogicComponent>> getComponents() {
        LinkedList<Element<String, LogicComponent>> result = new LinkedList<Element<String, LogicComponent>>();
        return result;
    }

    public void writeMEM(int adress, int data) {
        this.RAM.write(adress, data);
    }

    public int readMEM(int adress) {
        return this.RAM.read(adress);
    }

    public MEM getMEM() {
        return this.RAM;
    }
}

