/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import main.GraphicsPanel;
import util.Messages;
import util.NameConnector;
import util.SimObserver;

public class SignalsDialog
extends JDialog
implements SimObserver {
    private static final long serialVersionUID = 1L;
    private JPanel signals = new JPanel();
    private JScrollPane leftPanel = new JScrollPane();
    private JTable leftTable = new JTable();
    private JScrollPane rightPanel = new JScrollPane();
    private JTable rightTable = new JTable();
    private JButton drawButton = new JButton();
    private JButton clearButton = new JButton();
    public GraphicsPanel gp;

    public SignalsDialog() {
        this.setIconImage(new ImageIcon("src/images/btnCompile.png").getImage());
        this.signals.setBackground(new Color(255, 255, 255));
        this.signals.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getString("SignalsDialog.Signals"), 2, 2, null, new Color(0, 0, 255)));
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SignalsDialog.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        List<String> names = NameConnector.listPinNames();
        Object[][] leftObjects = new Object[(names.size() + 1) / 2][];
        int i = 0;
        while (i < leftObjects.length) {
            Object[] objectArray = new Object[2];
            objectArray[0] = names.get(i);
            leftObjects[i] = objectArray;
            ++i;
        }
        Object[][] rightObjects = new Object[names.size() / 2][];
        int i2 = 0;
        while (i2 < rightObjects.length) {
            Object[] objectArray = new Object[2];
            objectArray[0] = names.get(leftObjects.length + i2);
            rightObjects[i2] = objectArray;
            ++i2;
        }
        this.leftTable.setModel(new DefaultTableModel(leftObjects, new String[]{Messages.getString("SignalsDialog.Signal"), Messages.getString("SignalsDialog.Check")}){
            Class<?>[] types;
            {
                this.types = new Class[]{String.class, Boolean.class};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.leftPanel.setViewportView(this.leftTable);
        this.leftTable.getColumnModel().getColumn(0).setResizable(false);
        this.leftTable.getColumnModel().getColumn(1).setResizable(false);
        this.rightTable.setModel(new DefaultTableModel(rightObjects, new String[]{Messages.getString("SignalsDialog.Signal"), Messages.getString("SignalsDialog.Check")}){
            Class<?>[] types;
            {
                this.types = new Class[]{String.class, Boolean.class};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.rightPanel.setViewportView(this.rightTable);
        this.rightTable.getColumnModel().getColumn(0).setResizable(false);
        this.rightTable.getColumnModel().getColumn(1).setResizable(false);
        this.drawButton.setText(Messages.getString("SignalsDialog.Draw_signals"));
        this.drawButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignalsDialog.this.gp.addSignalNames(SignalsDialog.this.listSelectedSignals());
                SignalsDialog.this.gp.validate();
                SignalsDialog.this.gp.repaint();
            }
        });
        this.clearButton.setText(Messages.getString("SignalsDialog.Clear_list"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SignalsDialog.this.resetCheckBoxes();
            }
        });
        GroupLayout signaliLayout = new GroupLayout(this.signals);
        this.signals.setLayout(signaliLayout);
        signaliLayout.setHorizontalGroup(signaliLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(signaliLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addGroup(signaliLayout.createSequentialGroup().addComponent(this.leftPanel, -2, 201, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightPanel, -2, 201, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addComponent(this.drawButton, -1, 201, Short.MAX_VALUE).addComponent(this.clearButton, -1, 201, Short.MAX_VALUE)));
        signaliLayout.setVerticalGroup(signaliLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, signaliLayout.createSequentialGroup().addContainerGap().addGroup(signaliLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftPanel, -1, 332, Short.MAX_VALUE).addComponent(this.rightPanel, -1, 332, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.drawButton, -2, 40, -2).addComponent(this.clearButton, -2, 40, -2)));
        this.add(this.signals);
        this.setSize(450, 500);
        this.setLocation(200, 100);
    }

    public List<String> listSelectedSignals() {
        String name;
        Object o;
        LinkedList<String> names = new LinkedList<String>();
        int i = 0;
        while (i < this.leftTable.getRowCount()) {
            try {
                o = this.leftTable.getValueAt(i, 1);
                if (o != null && ((Boolean)o).booleanValue()) {
                    name = this.leftTable.getValueAt(i, 0).toString();
                    names.add(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        i = 0;
        while (i < this.rightTable.getRowCount()) {
            try {
                o = this.rightTable.getValueAt(i, 1);
                if (o != null && ((Boolean)o).booleanValue()) {
                    name = this.rightTable.getValueAt(i, 0).toString();
                    names.add(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return names;
    }

    public void resetCheckBoxes() {
        int i = 0;
        while (i < this.leftTable.getRowCount()) {
            this.leftTable.getModel().setValueAt(false, i, 1);
            ++i;
        }
        this.leftTable.clearSelection();
        i = 0;
        while (i < this.rightTable.getRowCount()) {
            this.rightTable.getModel().setValueAt(false, i, 1);
            ++i;
        }
        this.rightTable.clearSelection();
    }

    public void init() {
    }

    @Override
    public void update() {
    }

    public SimObserver getObserver() {
        return this;
    }
}

