/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import logic.components.MEM;
import main.Main;
import shemes.components.MemorijaOperaciona;
import util.Messages;
import util.NameConnector;
import util.Parameters;
import util.SimObserver;

public class MemoryDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    MemoryPanel panel;
    String dataFormat;
    int maxInt;

    public MemoryDialog() {
        this.setTitle(Messages.getString("MemoryDialog.Memory"));
        this.setIconImage(Main.getIcon());
        this.panel = new MemoryPanel();
        this.panel.setSadrzalacMemorije(this);
        this.add(this.panel);
        this.getRootPane().registerKeyboardAction(this.panel, KeyStroke.getKeyStroke(27, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg) {
                MemoryDialog.this.setVisible(false);
                Main.centralPanel.update(false);
            }
        });
        this.setModal(false);
        this.setResizable(false);
        this.dataFormat = Parameters.sizeMemData == 8 ? "%02x" : (Parameters.sizeMemData == 16 ? "%04x" : "%08x");
        this.maxInt = (1 << Parameters.sizeMemData) - 1;
        this.setSize(500, 300);
        this.setLocation(50, Main.checkLocation(50));
        this.setVisible(false);
    }

    public void init() {
        this.panel.init();
    }

    public SimObserver getObserver() {
        return this.panel;
    }

    public class MemoryPanel
    extends JPanel
    implements ActionListener,
    SimObserver {
        private static final long serialVersionUID = 1L;
        private JButton read;
        private JButton write;
        private JButton cancel;
        private JDialog greska;
        private JDialog potvrdaread;
        private JDialog potvrdawrite;
        private boolean error;
        private JTextField[] address;
        private JTextField[] data;
        private JTextField adr;
        private JTextField val;
        private MEM mem;
        private JDialog sadrzalacMemorije;
        private int firstAddress = 0;

        public JDialog getSadrzalacMemorije() {
            return this.sadrzalacMemorije;
        }

        public void setSadrzalacMemorije(JDialog sadrzalacMemorije) {
            this.sadrzalacMemorije = sadrzalacMemorije;
        }

        public void setMemory(MEM m) {
            this.mem = m;
        }

        public MemoryPanel() {
            this.setLayout(new BorderLayout());
            this.setBackground(Color.white);
            this.mem = ((MemorijaOperaciona)NameConnector.getSchema("Mem1")).getMEM();
        }

        public void init() {
            Color bgcolor = Color.white;
            JPanel dataPanel = new JPanel(new GridLayout(10, 1));
            dataPanel.setBackground(bgcolor);
            this.data = new JTextField[100];
            int index = 0;
            int j = 0;
            while (j < 10) {
                JPanel panel = new JPanel(new GridLayout(1, 10));
                panel.setBackground(bgcolor);
                int i = 0;
                while (i < 10) {
                    this.data[index] = new JTextField(5);
                    this.data[index].setEnabled(false);
                    this.data[index].setDisabledTextColor(Color.BLACK);
                    this.data[index].setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                    this.data[index].setColumns(3);
                    String s = String.format(MemoryDialog.this.dataFormat, this.mem.read(index));
                    this.data[index].setText(s);
                    panel.add(this.data[index]);
                    ++i;
                    ++index;
                }
                dataPanel.add(panel);
                ++j;
            }
            JPanel BigCenter = new JPanel(new BorderLayout());
            BigCenter.add((Component)dataPanel, "Center");
            JPanel addressPanel = new JPanel(new GridLayout(10, 1));
            addressPanel.setBackground(bgcolor);
            this.address = new JTextField[10];
            int temp = this.firstAddress;
            int i = 0;
            while (i < 10) {
                this.address[i] = new JTextField(10);
                this.address[i].setEnabled(false);
                this.address[i].setDisabledTextColor(Color.BLACK);
                this.address[i].setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                this.address[i].setColumns(7);
                String s = String.valueOf(Integer.toHexString(temp)) + "-" + Integer.toHexString(temp + 9) + ":";
                this.address[i].setText(s);
                temp += 10;
                addressPanel.add(this.address[i]);
                ++i;
            }
            BigCenter.add((Component)addressPanel, "West");
            JPanel BigSouth = new JPanel(new GridLayout(2, 1));
            BigSouth.setBackground(bgcolor);
            JPanel labeltext = new JPanel(new GridLayout(1, 4));
            labeltext.setBackground(bgcolor);
            JLabel labadr = new JLabel(Messages.getString("MemoryDialog.Address"));
            labeltext.add(labadr);
            labadr.setHorizontalAlignment(4);
            this.adr = new JTextField(5);
            this.adr.setColumns(3);
            this.adr.setText(String.format("%04x", 0));
            labeltext.add(this.adr);
            JLabel labval = new JLabel(Messages.getString("MemoryDialog.Value"));
            labeltext.add(labval);
            labval.setHorizontalAlignment(4);
            this.val = new JTextField(5);
            this.val.setColumns(3);
            this.val.setText(String.format(MemoryDialog.this.dataFormat, 0));
            labeltext.add(this.val);
            BigSouth.add(labeltext);
            JPanel buttons = new JPanel(new GridLayout(1, 3));
            buttons.setBackground(bgcolor);
            this.read = new JButton(Messages.getString("MemoryDialog.Read"));
            this.read.addActionListener(this);
            buttons.add(this.read);
            this.write = new JButton(Messages.getString("MemoryDialog.Write"));
            this.write.addActionListener(this);
            buttons.add(this.write);
            this.cancel = new JButton(Messages.getString("MemoryDialog.Cancel"));
            this.cancel.addActionListener(this);
            buttons.add(this.cancel);
            BigSouth.add(buttons);
            this.add((Component)BigCenter, "Center");
            this.add((Component)BigSouth, "South");
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getActionCommand() != null && arg0.getActionCommand().equals(Messages.getString("MemoryDialog.Read"))) {
                int adrtext = this.proveriAdresu(this.adr.getText());
                if (!this.error) {
                    this.firstAddress = adrtext;
                    this.repaint();
                    this.adr.setText(String.format("%04x", 0));
                    this.val.setText(String.format(MemoryDialog.this.dataFormat, 0));
                } else {
                    this.error = false;
                    this.adr.setText(String.format("%04x", 0));
                    this.val.setText(String.format(MemoryDialog.this.dataFormat, 0));
                    this.showReadError();
                }
            } else if (arg0.getActionCommand() != null && arg0.getActionCommand().equals(Messages.getString("MemoryDialog.Write"))) {
                int adrtext = this.proveriAdresu(this.adr.getText());
                int valtext = this.proveriVred(this.val.getText());
                if (!this.error) {
                    this.firstAddress = adrtext;
                    this.mem.write(adrtext, valtext);
                    this.repaint();
                    this.adr.setText(String.format("%04x", 0));
                    this.val.setText(String.format(MemoryDialog.this.dataFormat, 0));
                } else {
                    this.error = false;
                    this.adr.setText(String.format("%04x", 0));
                    this.val.setText(String.format(MemoryDialog.this.dataFormat, 0));
                    this.showWriteError();
                }
            } else {
                this.sadrzalacMemorije.setVisible(false);
            }
        }

        public void showWriteError() {
            this.greska = new JDialog();
            this.greska.setSize(550, 150);
            this.greska.setLocation(200, 200);
            this.greska.setModal(true);
            this.greska.setTitle(Messages.getString("MemoryDialog.Greska"));
            JPanel osnovni = new JPanel(new GridLayout(2, 1));
            JLabel lab = new JLabel(Messages.getString("MemoryDialog.Poruka_greska_adresa"));
            lab.setHorizontalAlignment(0);
            osnovni.add(lab);
            JButton ok = new JButton(Messages.getString("MemoryDialog.U_redu"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MemoryPanel.this.greska.setVisible(false);
                }
            });
            JPanel tmp = new JPanel();
            tmp.add(ok);
            tmp.setBackground(Color.white);
            osnovni.add(tmp);
            osnovni.setBackground(Color.white);
            this.greska.add(osnovni);
            this.greska.setVisible(true);
        }

        public void showWriteOK() {
            this.potvrdawrite = new JDialog();
            this.potvrdawrite.setIconImage(Main.getIcon());
            this.potvrdawrite.setSize(550, 100);
            this.potvrdawrite.setLocation(200, 200);
            this.potvrdawrite.setModal(true);
            this.potvrdawrite.setTitle(Messages.getString("MemoryDialog.Potvrda_upisa"));
            JPanel osnovni = new JPanel(new GridLayout(2, 1));
            JLabel lab = new JLabel(Messages.getString("MemoryDialog.Poruka_uspesan_uspis"));
            lab.setHorizontalAlignment(0);
            osnovni.add(lab);
            JButton ok = new JButton(Messages.getString("MemoryDialog.U_redu"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MemoryPanel.this.potvrdawrite.setVisible(false);
                }
            });
            JPanel tmp = new JPanel();
            tmp.add(ok);
            tmp.setBackground(Color.white);
            osnovni.add(tmp);
            osnovni.setBackground(Color.white);
            this.potvrdawrite.add(osnovni);
            this.potvrdawrite.setVisible(true);
        }

        public void showReadError() {
            this.greska = new JDialog();
            this.greska.setIconImage(Main.getIcon());
            this.greska.setSize(550, 150);
            this.greska.setLocation(200, 200);
            this.greska.setModal(true);
            this.greska.setTitle(Messages.getString("MemoryDialog.Greska"));
            JPanel osnovni = new JPanel(new GridLayout(2, 1));
            JLabel lab = new JLabel(Messages.getString("MemoryDialog.Poruka_neuspesno_pozicioniranje"));
            lab.setHorizontalAlignment(0);
            osnovni.add(lab);
            JButton ok = new JButton(Messages.getString("MemoryDialog.U_redu"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MemoryPanel.this.greska.setVisible(false);
                }
            });
            JPanel tmp = new JPanel();
            tmp.add(ok);
            tmp.setBackground(Color.white);
            osnovni.add(tmp);
            osnovni.setBackground(Color.white);
            this.greska.add(osnovni);
            this.greska.setVisible(true);
        }

        public void showReadOK() {
            this.potvrdaread = new JDialog();
            this.potvrdaread.setIconImage(Main.getIcon());
            this.potvrdaread.setSize(550, 100);
            this.potvrdaread.setLocation(200, 200);
            this.potvrdaread.setModal(true);
            this.potvrdaread.setTitle(Messages.getString("MemoryDialog.Potvrda_citanja"));
            JPanel osnovni = new JPanel(new GridLayout(2, 1));
            JLabel lab = new JLabel(Messages.getString("MemoryDialog.Poruka_uspesno_pozicioniranje"));
            lab.setHorizontalAlignment(0);
            osnovni.add(lab);
            JButton ok = new JButton(Messages.getString("MemoryDialog.U_redu"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MemoryPanel.this.potvrdaread.setVisible(false);
                }
            });
            JPanel tmp = new JPanel();
            tmp.add(ok);
            tmp.setBackground(Color.white);
            osnovni.add(tmp);
            osnovni.setBackground(Color.white);
            this.potvrdaread.add(osnovni);
            this.potvrdaread.setVisible(true);
        }

        private int proveriAdresu(String text) {
            int val = 0;
            try {
                val = Integer.parseInt(text, 16);
                if (val > Integer.parseInt("EFFF", 16)) {
                    this.error = true;
                }
                return val;
            }
            catch (Exception e) {
                this.error = true;
                return 0;
            }
        }

        private int proveriVred(String text) {
            int val;
            try {
                val = Integer.parseInt(text, 16);
            }
            catch (Exception e) {
                this.error = true;
                return 0;
            }
            if (MemoryDialog.this.maxInt < val) {
                this.error = true;
            }
            return val;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.adr.setText(String.format("%04x", 0));
            this.val.setText(String.format(MemoryDialog.this.dataFormat, 0));
            if (this.firstAddress + 99 >= Integer.parseInt("EFFF", 16)) {
                this.firstAddress = Integer.parseInt("EFFF", 16) - 99;
            }
            int i = 0;
            while (i < 100) {
                String s = String.format(MemoryDialog.this.dataFormat, this.mem.read(this.firstAddress + i));
                this.data[i].setText(s);
                ++i;
            }
            int temp = this.firstAddress;
            int i2 = 0;
            while (i2 < 10) {
                String s = String.valueOf(Integer.toHexString(temp)) + "-" + Integer.toHexString(temp + 9) + ":";
                this.address[i2].setText(s);
                temp += 10;
                ++i2;
            }
        }

        @Override
        public void update() {
            if (this.isVisible() && this.isChanged()) {
                this.repaint();
            }
        }

        public boolean isChanged() {
            boolean result = false;
            int i = 0;
            while (i < 100) {
                String s = String.format(MemoryDialog.this.dataFormat, this.mem.read(this.firstAddress + i));
                if (!this.data[i].getText().equals(s)) {
                    result = true;
                    break;
                }
                ++i;
            }
            return result;
        }
    }
}

