/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import logic.Execution;
import logic.Netlist;
import main.CommandStatusPanel;
import main.FlipflopDialog;
import main.GraphicsPanel;
import main.MemoryDialog;
import main.MenuPanel;
import main.MicrocodeEditorPanel;
import main.ParameterEditorPanel;
import main.RegisterDialog;
import main.SignalsDialog;
import main.SimMenu;
import main.SimulatorActions;
import main.TreePanel;
import main.WorkingPanel;
import shemes.AbstractSchema;
import shemes.Schema;
import shemes.components.Configuration;
import util.Element;
import util.Log;
import util.Messages;
import util.NameConnector;
import util.Parameters;
import util.SimObserver;
import util.TimeHistory;
import util.ValidationElement;

public class Main
extends JFrame
implements SimObserver {
    private static String SIMULATORNAME = Messages.getString("Main.SIMULATORNAME");
    public static final String ICON = "src/images/btnCompile.png";
    public static List<Schema> schemas;
    public static Schema currentScheme;
    public static JMenuBar menuBar;
    public static WorkingPanel centralPanel;
    public static TimeHistory history;
    public static JTabbedPane southPanel;
    public static GraphicsPanel graphsPanel;
    public static ParameterEditorPanel parameterEditorPanel;
    public static MicrocodeEditorPanel microcodeEditorPanel;
    public static JTextArea errorArea;
    public static CommandStatusPanel eastPanel;
    public static JTextArea traceArea;
    public static JPanel westPanel;
    public static TreePanel threePanel;
    public static MenuPanel menuPanel;
    public static MemoryDialog dialogMem;
    public static RegisterDialog dialogRegs;
    public static FlipflopDialog dialogFlipflops;
    public static SignalsDialog dialogSignals;
    public static List<SimObserver> observers;
    public static Main mainWindow;
    public static int editorPanelId;
    public static int graphsPanelId;
    public static int errorPanelId;
    public static int microcodePanelId;

    public Main(List<Schema> schemas) {
        super(SIMULATORNAME);
        mainWindow = this;
        this.setIconImage(Main.getIcon());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SimulatorActions.close();
            }
        });
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        menuBar = new SimMenu();
        this.setJMenuBar(menuBar);
        Main.schemas = schemas;
        currentScheme = AbstractSchema.getSchenaWithGui(schemas.get(0));
        centralPanel = new WorkingPanel(currentScheme.getGui());
        centralPanel.setBackground(Color.WHITE);
        centralPanel.setSize(new Dimension(800, 750));
        parameterEditorPanel = new ParameterEditorPanel();
        JScrollPane editorPanelScroll = new JScrollPane(parameterEditorPanel);
        editorPanelScroll.setBackground(Color.WHITE);
        editorPanelScroll.setSize(new Dimension(800, 175));
        microcodeEditorPanel = new MicrocodeEditorPanel();
        JScrollPane microcodePanelScroll = new JScrollPane(microcodeEditorPanel);
        microcodePanelScroll.setBackground(Color.WHITE);
        microcodePanelScroll.setSize(new Dimension(800, 175));
        graphsPanel = new GraphicsPanel();
        JScrollPane graphsPanelScroll = new JScrollPane(graphsPanel);
        graphsPanelScroll.setBackground(Color.WHITE);
        graphsPanelScroll.setSize(new Dimension(800, 175));
        errorArea = new JTextArea();
        errorArea.setEditable(false);
        errorArea.setFont(new Font("Consolas", 0, 14));
        errorArea.setForeground(Color.RED);
        errorArea.append(Log.getLog());
        JScrollPane errorArealScroll = new JScrollPane(errorArea);
        errorArealScroll.setBackground(Color.WHITE);
        errorArealScroll.setSize(new Dimension(800, 175));
        southPanel = new JTabbedPane();
        southPanel.setTabLayoutPolicy(1);
        southPanel.add(Messages.getString("Main.ConfigurationPanelName"), editorPanelScroll);
        editorPanelId = 0;
        southPanel.add(Messages.getString("Main.TimeDiagramPanelName"), graphsPanelScroll);
        graphsPanelId = 1;
        southPanel.add(Messages.getString("Main.ErrorLogPanelName"), errorArealScroll);
        errorPanelId = 2;
        southPanel.add(Messages.getString("Main.MicrocodePanelName"), microcodePanelScroll);
        microcodePanelId = 3;
        JSplitPane splitPane = new JSplitPane(0, centralPanel, southPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(750);
        JPanel middle = new JPanel();
        middle.setLayout(new BorderLayout());
        middle.setBackground(Color.WHITE);
        middle.setMinimumSize(new Dimension(800, 950));
        middle.setSize(new Dimension(800, 950));
        middle.add((Component)splitPane, "Center");
        this.add("Center", middle);
        eastPanel = new CommandStatusPanel();
        Dimension d = new Dimension(160, 620);
        eastPanel.setMaximumSize(d);
        eastPanel.setMinimumSize(d);
        eastPanel.setPreferredSize(d);
        eastPanel.setSize(d);
        traceArea = Main.eastPanel.traceArea;
        this.add("East", eastPanel);
        westPanel = new JPanel();
        westPanel.setLayout(new BorderLayout());
        threePanel = new TreePanel(schemas);
        westPanel.add((Component)threePanel, "Center");
        menuPanel = new MenuPanel();
        westPanel.add((Component)menuPanel, "South");
        this.add("West", westPanel);
        observers = new LinkedList<SimObserver>();
        dialogMem = new MemoryDialog();
        dialogMem.init();
        observers.add(dialogMem.getObserver());
        dialogRegs = new RegisterDialog();
        dialogRegs.init();
        observers.add(dialogRegs.getObserver());
        dialogFlipflops = new FlipflopDialog();
        dialogFlipflops.init();
        observers.add(dialogFlipflops.getObserver());
        dialogSignals = new SignalsDialog();
        dialogSignals.init();
        observers.add(dialogSignals.getObserver());
        Main.dialogSignals.gp = graphsPanel;
    }

    public void reload(List<Schema> schemas) {
        Main.schemas = schemas;
        currentScheme = AbstractSchema.getSchenaWithGui(schemas.get(0), currentScheme.getName());
        centralPanel.changeSchema(currentScheme.getGui());
        TreePanel threePanel = new TreePanel(schemas);
        Component tmp = null;
        Component[] componentArray = westPanel.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component o = componentArray[n2];
            if (o instanceof TreePanel) {
                tmp = o;
            }
            ++n2;
        }
        westPanel.remove(tmp);
        westPanel.add((Component)threePanel, "Center");
        eastPanel.reset();
    }

    public static Image getIcon() {
        return new ImageIcon(ICON).getImage();
    }

    public void start() {
        this.pack();
        this.validate();
        this.setSize(1200, 1000);
        this.setExtendedState(this.getExtendedState() | 6);
        this.setVisible(true);
    }

    public static void main(String[] args) {
        Log.reset();
        Parameters.init();
        mainWindow = Main.loadSimulation(mainWindow);
        mainWindow.start();
    }

    public static void load() {
        Log.reset();
        Parameters.init();
        mainWindow = Main.loadSimulation(mainWindow);
        mainWindow.validate();
    }

    public static Main loadSimulation(Main main) {
        NameConnector.reset();
        Execution.reset();
        List<Schema> schemas = Main.initSchems();
        for (Schema schema : schemas) {
            schema.initComponent();
        }
        for (Schema schema : schemas) {
            schema.initConections();
        }
        for (Schema schema : schemas) {
            schema.initGui();
        }
        if (main == null) {
            main = new Main(schemas);
        } else {
            main.reload(schemas);
        }
        Log.setLogAreas(traceArea, errorArea);
        Main.validate(schemas);
        history = new TimeHistory(NameConnector.listPinNames());
        history.addObserver(graphsPanel);
        graphsPanel.setHistory(history);
        Execution.setHistory(history);
        Execution.setComponent(Netlist.extractAllComponent(Execution.getSequentialComponent()));
        Execution.init(true);
        microcodeEditorPanel.update();
        return main;
    }

    private static void validate(List<Schema> schemas) {
        SimulatorActions.setErrorLogFlag(false);
        LinkedList<Element<String[], ValidationElement>> list = new LinkedList<Element<String[], ValidationElement>>();
        for (Schema schema : schemas) {
            List<Element<String[], ValidationElement>> tmp = schema.validate();
            list.addAll(tmp);
        }
        if (list.size() > 0) {
            SimulatorActions.setErrorLogFlag(true);
        }
        for (Element element : list) {
            StringBuffer sb = new StringBuffer();
            String[] stringArray = (String[])element.name;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                sb = sb.append(s).append("\t");
                ++n2;
            }
            sb = sb.append(((ValidationElement)element.value).toString());
            Log.errorLog(sb.toString());
        }
    }

    private static List<Schema> initSchems() {
        LinkedList<Schema> result = new LinkedList<Schema>();
        result.add(new Configuration());
        return result;
    }

    public static void setLookAndFeel() {
        String lookAndFeel = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        try {
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void update() {
        for (SimObserver observer : observers) {
            observer.update();
        }
    }

    public static int checkLocation(int location) {
        int result = location;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int height = (int)screenSize.getHeight();
        if (location > height) {
            result = 0;
        }
        return result;
    }

    public static CommandStatusPanel getCommandStatusPanel() {
        return eastPanel;
    }
}

