/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import logic.Execution;
import logic.Pin;
import util.NameConnector;
import util.TimeHistory;

public class GraphicsPanel
extends JPanel
implements TimeHistory.TimeHistoryObserver {
    private static final long serialVersionUID = 1L;
    private final int STEPH = 21;
    private final int STEPV = 21;
    private final int IMPULS_HEIGHT = 15;
    private final int START_X = 86;
    private final int START_Y = 37;
    private final int START_XLAB = 15;
    private final int START_YLAB = 40;
    private final int STEP_XGRID = 21;
    private final int STEP_YGRID = 10;
    private final int GRID_YOFFSET = 30;
    private final float STORK_SIZE = 3.0f;
    private final Color GRID_CLR = new Color(230, 230, 230);
    private final Color LINE_CLR = Color.BLUE;
    private final int MAX_CLK = 32;
    List<PanelData> data = new LinkedList<PanelData>();
    Set<String> usedNames = new HashSet<String>();
    public TimeHistory history = null;
    private int clk = 0;
    private int startClk = 0;

    public GraphicsPanel() {
        this.adjustSize(new Dimension(810, 200));
        this.setBackground(Color.WHITE);
        MoveXListener mouseX = new MoveXListener();
        this.addMouseListener(mouseX);
        this.addMouseMotionListener(mouseX);
        MoveYListener mouseY = new MoveYListener();
        this.addMouseListener(mouseY);
        this.addMouseMotionListener(mouseY);
    }

    public void adjustSize(Dimension size) {
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
        this.setSize(size);
        this.validate();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        Color tmp = g.getColor();
        Dimension size = this.getParent().getSize();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, Math.max(this.getWidth(), (int)size.getWidth()), Math.max(this.getHeight(), (int)size.getHeight()));
        g.setColor(tmp);
        if (this.data.size() > 0) {
            Graphics2D graph = (Graphics2D)g;
            this.drawDiagram(graph);
            this.getToolkit().sync();
        }
    }

    private void drawGrid(int startTime, int endTime, Graphics2D graph) {
        int position;
        Color tmp = graph.getColor();
        int i = 0;
        while (i < this.data.size()) {
            graph.drawString(this.data.get((int)i).name, 15, 40 + i * 21);
            ++i;
        }
        Font pom = graph.getFont();
        graph.setFont(new Font("Times New Roman", 0, 10));
        graph.setColor(Color.BLACK);
        int i2 = startTime;
        while (i2 < endTime + 1) {
            position = i2 - startTime;
            graph.drawString(Integer.toString(i2), 86 + position * 21, 10);
            ++i2;
        }
        graph.setFont(pom);
        graph.setColor(this.GRID_CLR);
        i2 = startTime;
        while (i2 < endTime + 1) {
            graph.setStroke(new BasicStroke(1.0f, 2, 2));
            position = i2 - startTime;
            graph.drawLine(86 + position * 21, 30, 86 + position * 21, this.getHeight() - 10);
            ++i2;
        }
        graph.setColor(tmp);
    }

    private void drawLowLine(int num, int sig, Graphics2D graph) {
        graph.setColor(this.LINE_CLR);
        graph.setStroke(new BasicStroke(3.0f));
        graph.drawLine(86 + num * 21, 37 + sig * 21, 86 + (num + 1) * 21, 37 + sig * 21);
    }

    private void drawHighLine(int num, int sig, Graphics2D graph) {
        graph.setColor(this.LINE_CLR);
        graph.setStroke(new BasicStroke(3.0f));
        graph.drawLine(86 + num * 21, 37 + sig * 21 - 15, 86 + (num + 1) * 21, 37 + sig * 21 - 15);
    }

    private void drawHIZLine(int num, int sig, Graphics2D graph) {
        graph.setColor(this.LINE_CLR);
        graph.setStroke(new BasicStroke(3.0f));
        graph.drawLine(86 + num * 21, 37 + sig * 21 - 7, 86 + (num + 1) * 21, 37 + sig * 21 - 7);
    }

    private void drawChange(int num, int sig, int prev, int next, Graphics2D graph) {
        graph.setColor(this.LINE_CLR);
        graph.setStroke(new BasicStroke(3.0f));
        int y1 = 37 + sig * 21 - 15;
        int y2 = 37 + sig * 21;
        if (prev == 2 && next == 1 || prev == 1 && next == 2) {
            y2 = 37 + sig * 21 - 7;
        }
        if (prev == 2 && next == 0 || prev == 0 && next == 2) {
            y1 = 37 + sig * 21 - 7;
        }
        graph.drawLine(86 + num * 21, y1, 86 + num * 21, y2);
    }

    private int calcNumverOfVisibleCLKs() {
        Dimension size = this.getParent().getSize();
        int result = ((int)size.getWidth() - 86) / 21 - 1;
        result = Math.max(result, 32);
        return result;
    }

    private void drawDiagram(Graphics2D graph) {
        int startTime = Math.max(0, this.startClk);
        this.startClk = startTime = Math.min(startTime, this.history.getHistorySize());
        int endTime = Math.min(startTime + this.calcNumverOfVisibleCLKs(), this.history.getHistorySize());
        this.drawGrid(startTime, endTime, graph);
        int j = 0;
        while (j < this.data.size()) {
            int position;
            int i;
            PanelData pData = this.data.get(j);
            if (pData.numLines == 1) {
                i = startTime;
                while (i < endTime) {
                    int state = this.history.getSignalFromHistory(i, pData.name);
                    position = i - startTime;
                    if (state == 1) {
                        this.drawHighLine(position, j, graph);
                    } else if (state == 0) {
                        this.drawLowLine(position, j, graph);
                    } else {
                        this.drawHIZLine(position, j, graph);
                    }
                    int prev = Integer.parseInt(pData.prev);
                    if (position != 0 && prev != state) {
                        this.drawChange(position, j, prev, state, graph);
                    }
                    pData.prev = "" + state;
                    ++i;
                }
            } else {
                i = startTime;
                while (i < endTime) {
                    String state = this.history.getMultiSignalFromHistory(i, pData.name);
                    position = i - startTime;
                    if (state.equals("Z")) {
                        this.drawHIZLine(position, j, graph);
                    } else {
                        this.drawHighLine(position, j, graph);
                        this.drawLowLine(position, j, graph);
                    }
                    if (position != 0 && !pData.prev.equals(state)) {
                        this.drawChange(position, j, pData.prev, state, graph);
                    }
                    pData.prev = state;
                    ++i;
                }
            }
            ++j;
        }
    }

    private void drawChange(int position, int j, String prev, String state, Graphics2D graph) {
        if (!state.equals("Z")) {
            int val = Integer.parseInt(state);
            state = Integer.toString(val, 16);
            graph.drawString(state, (float)(86 + position * 21) + 3.0f, (float)(40 + j * 21) - 3.0f - 3.0f);
        }
        graph.setColor(this.LINE_CLR);
        graph.setStroke(new BasicStroke(3.0f));
        int y1 = 37 + j * 21 - 15;
        int y2 = 37 + j * 21;
        graph.drawLine(86 + position * 21, y1, 86 + position * 21, y2);
    }

    public void addSignalNames(List<String> names) {
        this.data.clear();
        this.usedNames.clear();
        for (String name : names) {
            if (this.usedNames.contains(name)) continue;
            PanelData d = new PanelData();
            d.name = name;
            Pin pin = NameConnector.getPin(name);
            if (pin != null) {
                d.numLines = pin.getNumOfLines();
            }
            this.data.add(d);
            this.usedNames.add(name);
        }
        this.adjustSize(new Dimension(this.getWidth(), 40 + (this.data.size() + 1) * 21));
        this.validate();
        this.getToolkit().sync();
        this.repaint();
    }

    public void setHistory(TimeHistory tdh) {
        this.history = tdh;
    }

    @Override
    public void update() {
        if (Execution.globalTime > 0) {
            this.setClk(Execution.globalTime);
        } else {
            this.clear();
        }
        this.repaint();
    }

    public void setClk(int clk) {
        if (this.clk != clk) {
            this.clk = clk;
            this.startClk = Math.max(0, clk - this.calcNumverOfVisibleCLKs());
            this.repaint();
        }
    }

    public void clear() {
        this.data.clear();
        this.usedNames.clear();
        this.clk = 0;
        this.startClk = 0;
    }

    private class MoveXListener
    extends MouseInputAdapter {
        int startX;

        private MoveXListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startX = e.getX();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updateSize(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        void updateSize(MouseEvent e) {
            int x = e.getX();
            int dX = (this.startX - x) / 21;
            if (dX != 0 && GraphicsPanel.this.startClk >= 0) {
                GraphicsPanel graphicsPanel = GraphicsPanel.this;
                graphicsPanel.startClk = graphicsPanel.startClk + dX;
                if (GraphicsPanel.this.startClk < 0) {
                    GraphicsPanel.this.startClk = 0;
                }
                this.startX = x;
                GraphicsPanel.this.repaint();
            }
        }
    }

    private class MoveYListener
    extends MouseInputAdapter {
        int startX;
        int startY;
        PanelData selectedLine;
        int startIndex;

        private MoveYListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startX = e.getX();
            this.startY = e.getY();
            this.startIndex = (this.startY - 40) / 21;
            if (this.startIndex >= 0 && this.startIndex < GraphicsPanel.this.data.size()) {
                this.selectedLine = GraphicsPanel.this.data.get(this.startIndex);
            } else {
                this.startIndex = -1;
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.updateSize(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        void updateSize(MouseEvent e) {
            if (this.startX < 86) {
                int y = e.getY();
                int currentIndex = (y - 40) / 21;
                if (currentIndex < 0 || currentIndex >= GraphicsPanel.this.data.size()) {
                    currentIndex = -1;
                }
                if (this.startIndex >= 0 && currentIndex >= 0 && this.startIndex != currentIndex) {
                    GraphicsPanel.this.data.remove(this.selectedLine);
                    if (GraphicsPanel.this.data.size() > currentIndex) {
                        GraphicsPanel.this.data.add(currentIndex, this.selectedLine);
                    } else {
                        GraphicsPanel.this.data.add(this.selectedLine);
                    }
                    this.startIndex = currentIndex;
                    GraphicsPanel.this.repaint();
                }
            }
        }
    }

    class PanelData {
        String name = "";
        String prev = "0";
        int numLines = 1;

        PanelData() {
        }
    }
}

