/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultCaret;
import logic.Execution;
import logic.Pin;
import main.Main;
import main.SimulatorActions;
import util.Messages;
import util.MicrocodeConverter;
import util.NameConnector;

public class CommandStatusPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    JPanel northeast = new JPanel();
    JScrollPane scrolltxt = new JScrollPane();
    JPanel southeast = new JPanel();
    JLabel CPUclock = new JLabel(Messages.getString("CommandStatusPanel.CPU_Clock"));
    JLabel Tcpu = new JLabel(Messages.getString("CommandStatusPanel.mPC"));
    JLabel PC = new JLabel(Messages.getString("CommandStatusPanel.PC"));
    JButton CLK = new JButton(Messages.getString("CommandStatusPanel.CLK+"));
    JButton INS = new JButton(Messages.getString("CommandStatusPanel.INSTRUCTION+"));
    JButton PRG = new JButton(Messages.getString("CommandStatusPanel.PROGRAM+"));
    JButton GOTO = new JButton(Messages.getString("CommandStatusPanel.GOTO"));
    JTextField end = new JTextField();
    JScrollPane scrollPane;
    JLabel phaseName = new JLabel(Messages.getString("CommandStatusPanel.Faza_izvrsavanja"));
    JLabel phase = new JLabel("-");
    JLabel signsName = new JLabel(Messages.getString("CommandStatusPanel.Microprogram"), 2);
    JLabel signs = new JLabel("-", 2);
    JLabel microprogramTrace = new JLabel(Messages.getString("CommandStatusPanel.Log"));
    JTextArea traceArea = new JTextArea();

    public CommandStatusPanel() {
        MicrocodeConverter microcodeConverter = MicrocodeConverter.microcodeConverter;
        this.phase.setText(microcodeConverter.getComment(NameConnector.getPin("Counter.mPC").getIntVal()) == null ? this.phase.getText() : microcodeConverter.getComment(NameConnector.getPin("Counter.mPC").getIntVal()));
        String s1 = microcodeConverter.getSteps(NameConnector.getPin("Counter.mPC").getIntVal()) == null ? this.signs.getText() : microcodeConverter.getSteps(NameConnector.getPin("Counter.mPC").getIntVal());
        s1 = "<html>" + s1 + "</html>";
        this.signs.setText(s1);
        this.signs.setAlignmentX(0.5f);
        this.northeast.setLayout(new GridLayout(2, 1));
        JPanel northeastI = new JPanel();
        northeastI.setLayout(new BoxLayout(northeastI, 1));
        this.CPUclock.setAlignmentX(0.5f);
        northeastI.add(this.CPUclock);
        this.Tcpu.setAlignmentX(0.5f);
        northeastI.add(this.Tcpu);
        this.PC.setAlignmentX(0.5f);
        northeastI.add(this.PC);
        this.CLK.addActionListener(new CLKActionListener());
        this.CLK.setAlignmentX(0.5f);
        northeastI.add(this.CLK);
        this.INS.addActionListener(new INSActionListener());
        this.INS.setAlignmentX(0.5f);
        northeastI.add(this.INS);
        this.PRG.addActionListener(new PRGActionListener());
        this.PRG.setAlignmentX(0.5f);
        northeastI.add(this.PRG);
        JPanel GOTOpanel = new JPanel(new GridLayout(1, 2));
        this.GOTO.addActionListener(new GOTOActionListener());
        this.GOTO.setAlignmentX(0.0f);
        GOTOpanel.add(this.GOTO);
        this.end.setAlignmentX(1.0f);
        GOTOpanel.add(this.end);
        northeastI.add(GOTOpanel);
        this.northeast.add(northeastI);
        JPanel northeastII = new JPanel();
        northeastII.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getString("CommandStatusPanel.Contril_unit_info"), 2, 2, null, new Color(0, 0, 255)));
        northeastII.setLayout(new BoxLayout(northeastII, 1));
        this.phaseName.setAlignmentX(0.5f);
        northeastII.add(this.phaseName);
        this.phaseName.setFont(new Font("D", 10, 13));
        this.phase.setAlignmentX(0.5f);
        northeastII.add(this.phase);
        this.signsName.setAlignmentX(0.5f);
        northeastII.add(this.signsName);
        this.signsName.setFont(new Font("D", 10, 13));
        this.signs.setMinimumSize(new Dimension(10, 40));
        northeastII.add(this.signs);
        this.northeast.add(northeastII);
        DefaultCaret caret = (DefaultCaret)this.traceArea.getCaret();
        caret.setUpdatePolicy(2);
        this.traceArea.setText("");
        this.traceArea.setEditable(false);
        this.traceArea.setAlignmentX(0.5f);
        this.southeast.setLayout(new BoxLayout(this.southeast, 1));
        this.microprogramTrace.setAlignmentX(0.5f);
        this.scrolltxt = new JScrollPane(this.traceArea);
        this.scrolltxt.setName(Messages.getString("CommandStatusPanel.KOD"));
        this.scrolltxt.setAlignmentX(0.5f);
        this.scrolltxt.setVerticalScrollBarPolicy(20);
        this.scrolltxt.setHorizontalScrollBarPolicy(30);
        this.southeast.add(this.scrolltxt);
        this.southeast.setBorder(new TitledBorder(UIManager.getBorder("TitledBorder.border"), Messages.getString("CommandStatusPanel.Log"), 2, 2, null, new Color(0, 0, 255)));
        this.setLayout(new GridLayout(2, 1));
        this.add(this.northeast);
        this.add(this.southeast);
    }

    public void reset() {
        this.scrolltxt.getVerticalScrollBar().setValue(0);
        this.end.setText("");
        this.traceArea.setText("");
        this.updateLabels();
        this.updateCUContext();
        this.enableNext();
        Main.centralPanel.update(true);
        Main.graphsPanel.validate();
        Main.graphsPanel.repaint();
        Main.mainWindow.update();
    }

    public void updateLabels() {
        this.CPUclock.setText(String.valueOf(Messages.getString("CommandStatusPanel.CPU_clock")) + Execution.globalTime);
        this.Tcpu.setText(String.valueOf(Messages.getString("CommandStatusPanel.Tcpu")) + Integer.toHexString(NameConnector.getPin("Counter.mPC").getIntVal()));
        this.PC.setText(String.valueOf(Messages.getString("CommandStatusPanel.PC1")) + Integer.toHexString(NameConnector.getPin("Fetch1.PC").getIntVal()));
    }

    public void updateCUContext() {
        Pin mPC = NameConnector.getPin("Counter.mPC");
        if (mPC != null) {
            MicrocodeConverter microcodeConverter = MicrocodeConverter.microcodeConverter;
            this.phase.setText(microcodeConverter.getComment(mPC.getIntVal()));
            String s1 = microcodeConverter.getSteps(mPC.getIntVal());
            s1 = "<html>" + s1 + "</html>";
            this.signs.setText(s1);
        }
    }

    public void validateNext() {
        if (!NameConnector.getPin("Exec2.START").getBoolVal()) {
            this.CLK.setEnabled(false);
            this.INS.setEnabled(false);
            this.PRG.setEnabled(false);
            this.GOTO.setEnabled(false);
        }
    }

    public void enableNext() {
        this.CLK.setEnabled(true);
        this.INS.setEnabled(true);
        this.PRG.setEnabled(true);
        this.GOTO.setEnabled(true);
    }

    public class CLKActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            SimulatorActions.gotoNextClkAction();
        }
    }

    public class GOTOActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            String time = CommandStatusPanel.this.end.getText();
            CommandStatusPanel.this.end.setText("");
            SimulatorActions.gotoTimeAction(time);
        }
    }

    public class INSActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            SimulatorActions.gotoNextInstructionAction();
        }
    }

    public class PRGActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent arg0) {
            SimulatorActions.gotoProgramEndAction();
        }
    }
}

