/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import logic.Pin;

public class MP
extends AbstractLogicComponent {
    private Pin[] ctrl;
    private Pin E;

    public MP(int in) {
        super(in, 1);
        this.ctrl = new Pin[this.calcCtrlPins(in)];
    }

    public void setCtrl(Pin[] ctrl) {
        this.ctrl = ctrl;
        int i = 0;
        while (i < ctrl.length) {
            ctrl[i].addChild(this);
            ++i;
        }
    }

    public void setCtrl(int index, Pin ctrl) {
        this.ctrl[index] = ctrl;
        ctrl.addChild(this);
    }

    public void setE(Pin e) {
        this.E = e;
        e.addChild(this);
    }

    private int calcCtrlPins(int in) {
        int ret = 0;
        while (in != 0) {
            if ((in >>= 1) <= 0) continue;
            ++ret;
        }
        return ret;
    }

    @Override
    public void func() {
        if (this.E != null && !this.E.getBoolVal()) {
            this.out[0].clear();
            return;
        }
        int index = 0;
        int i = 0;
        while (i < this.ctrl.length) {
            if (this.ctrl[i].getBoolVal()) {
                index += (int)Math.pow(2.0, i);
            }
            ++i;
        }
        if (this.in[index].isHighZ()) {
            if (this.out[0].isBool()) {
                this.out[0].setBoolVal(false);
            } else {
                this.out[0].setIntVal(0);
            }
        } else if (this.out[0].isBool()) {
            this.out[0].setBoolVal(this.in[index].getBoolVal());
        } else {
            this.out[0].setIntVal(this.in[index].getIntVal());
        }
    }

    public Pin getE() {
        return this.E;
    }

    public Pin[] getCtrl() {
        return this.ctrl;
    }

    public Pin getCtrl(int index) {
        return this.ctrl[index];
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }
}

