/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import logic.Pin;

public class CMP
extends AbstractLogicComponent {
    private Pin E;

    public void setE(Pin e) {
        this.E = e;
        e.addChild(this);
    }

    public Pin getE() {
        return this.E;
    }

    public CMP(int in) {
        super(in * 2, 3);
    }

    @Override
    public void func() {
        if (this.E != null && !this.E.getBoolVal()) {
            this.out[0].setBoolVal(false);
            this.out[1].setBoolVal(false);
            this.out[2].setBoolVal(false);
            return;
        }
        int A = 0;
        int B = 0;
        if (this.in[0].isBool()) {
            int i = 0;
            while (i < this.in.length / 2) {
                if (this.in[i].getBoolVal()) {
                    A += 1 << i;
                }
                if (this.in[i + this.in.length / 2].getBoolVal()) {
                    B += 1 << i;
                }
                ++i;
            }
        } else {
            A = this.in[0].getIntVal();
            B = this.in[1].getIntVal();
        }
        if (A > B) {
            this.out[0].setBoolVal(true);
            this.out[1].setBoolVal(false);
            this.out[2].setBoolVal(false);
        } else if (A < B) {
            this.out[0].setBoolVal(false);
            this.out[1].setBoolVal(false);
            this.out[2].setBoolVal(true);
        } else if (A == B) {
            this.out[0].setBoolVal(false);
            this.out[1].setBoolVal(true);
            this.out[2].setBoolVal(false);
        }
    }

    public Pin getEQL() {
        return this.out[1];
    }

    public Pin getGRT() {
        return this.out[0];
    }

    public Pin getLES() {
        return this.out[2];
    }

    public void setPinA(int index, Pin pin) {
        this.setInPin(index, pin);
    }

    public void setPinB(int index, Pin pin) {
        this.setInPin(index + this.in.length / 2, pin);
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }
}

