/*
 * Decompiled with CFR 0.152.
 */
package logic.components;

import logic.AbstractLogicComponent;
import util.Log;

public class Adapter
extends AbstractLogicComponent {
    private boolean mTos;
    private boolean mTom;

    public Adapter(int in, int out) {
        super(in, out);
        if (in == 1) {
            this.mTos = true;
        } else if (out == 1) {
            this.mTos = false;
        } else {
            Log.errorLog(":Error!!! Bad adapter arguments...");
        }
    }

    @Override
    public void func() {
        if (this.mTos) {
            int mval = this.in[0].getIntVal();
            if (mval > 0) {
                int j = 0;
                while (j < this.out.length) {
                    int mod = mval % 2;
                    mval >>= 1;
                    this.out[j].setBoolVal(mod == 1);
                    ++j;
                }
            } else {
                mval = (int)Math.pow(2.0, this.out.length) + mval;
                int j = 0;
                while (j < this.out.length) {
                    int mod = mval % 2;
                    mval >>= 1;
                    this.out[j].setBoolVal(mod == 1);
                    ++j;
                }
            }
        } else if (!this.mTom) {
            int val = 0;
            int i = 0;
            while (i < this.in.length) {
                if (this.in[i].getBoolVal()) {
                    val = (int)((double)val + Math.pow(2.0, i));
                } else if (!this.in[i].getBoolVal()) {
                    val = (int)((double)val + (double)this.in[i].getIntVal() * Math.pow(2.0, i * this.in[0].getNumOfLines()));
                }
                ++i;
            }
            this.out[0].setIntVal(val);
        } else {
            int val = 0;
            String b = "";
            int i = 0;
            while (i < this.in.length) {
                int temp = 0;
                temp = this.in[i].isBool() ? (this.in[i].getBoolVal() ? 1 : 0) : (this.in[i].getIntVal() >= 0 ? this.in[i].getIntVal() : (int)(Math.pow(2.0, this.in[i].getNumOfLines()) + (double)this.in[i].getIntVal()));
                String tb = Integer.toBinaryString(temp);
                while (tb.length() < this.in[i].getNumOfLines()) {
                    tb = String.valueOf(0) + tb;
                }
                b = String.valueOf(tb) + b;
                ++i;
            }
            int j = 0;
            while (j < b.length()) {
                try {
                    val = (int)((double)val + Math.pow(2.0, j) * (double)this.toInt(b.substring(b.length() - j - 1, b.length() - j)));
                }
                catch (Exception e) {
                    Log.errorLog(e, "Addapter " + this.name);
                }
                ++j;
            }
            this.out[0].setIntVal(val);
        }
    }

    private int toInt(String number) throws Exception {
        int ret = 0;
        try {
            ret = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            char c = number.charAt(0);
            switch (c) {
                case 'A': 
                case 'a': {
                    ret = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    ret = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    ret = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    ret = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    ret = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    ret = 15;
                    break;
                }
                default: {
                    throw new Exception("Nesto ne valja sa brojevima:" + number);
                }
            }
            return ret;
        }
        return ret;
    }

    public boolean isMTom() {
        return this.mTom;
    }

    public void setMTom(boolean tom) {
        this.mTom = tom;
    }

    @Override
    public void initArgs(String[] args) {
        this.args = args;
        this.name = args[1];
    }
}

