/*
 * Decompiled with CFR 0.152.
 */
package logic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.Pin;

public class Netlist {
    public static List<LogicComponent> extractAllComponent(List<LogicComponent> comps) {
        LinkedList<LogicComponent> result = new LinkedList<LogicComponent>();
        HashSet<LogicComponent> processed = new HashSet<LogicComponent>();
        LinkedList<LogicComponent> forProcessing = new LinkedList<LogicComponent>(comps);
        while (forProcessing.size() > 0) {
            LogicComponent comp = (LogicComponent)forProcessing.remove(0);
            if (!processed.contains(comp)) {
                for (Pin pin : comp.getAllOutPins()) {
                    if (pin == null || pin.getChildren() == null) continue;
                    for (LogicComponent lc : pin.getChildren()) {
                        if (processed.contains(lc)) continue;
                        forProcessing.add(lc);
                    }
                }
            }
            processed.add(comp);
        }
        result.addAll(processed);
        return result;
    }

    public static List<LogicComponent> extractAllCombinationalComponent(List<LogicComponent> comps) {
        LinkedList<LogicComponent> result = new LinkedList<LogicComponent>();
        for (LogicComponent comp : comps) {
            if (comp.isSeq()) continue;
            result.add(comp);
        }
        return result;
    }

    public static List<LogicComponent> extractAllSequentialComponent(List<LogicComponent> comps) {
        LinkedList<LogicComponent> result = new LinkedList<LogicComponent>();
        for (LogicComponent comp : comps) {
            if (!comp.isSeq()) continue;
            result.add(comp);
        }
        return result;
    }

    public static void printTypeStat(List<LogicComponent> comps) {
        HashMap<String, Integer> cnts = new HashMap<String, Integer>();
        for (LogicComponent comp : comps) {
            if (comp == null) continue;
            String name = comp.getClass().getSimpleName();
            Integer cnt = (Integer)cnts.get(name);
            if (cnt == null) {
                cnt = 0;
            }
            cnt = cnt + 1;
            cnts.put(name, cnt);
        }
        Object[] names = cnts.keySet().toArray(new String[cnts.size()]);
        Arrays.sort(names);
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            System.out.println(String.valueOf(name) + ":" + cnts.get(name));
            ++n2;
        }
    }
}

