/*
 * Decompiled with CFR 0.152.
 */
package gui.components;

import gui.Drawable;
import gui.GuiLine;
import gui.GuiPinLabel;
import gui.GuiPinLine;
import gui.GuiTextLabel;
import gui.components.DrawableComponentAbstract;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;
import logic.components.IntToBools;
import util.DrawUtils;

public class IntToBoolsGui
extends DrawableComponentAbstract {
    Point inPortPosition = null;
    Point[] outPortPositions;
    private static final int DISTANCE = 15;

    public IntToBoolsGui(LogicComponent i2b, int x, int y, String[] args, boolean printOutPortName) {
        this(i2b, x, y, args, true, printOutPortName);
    }

    public IntToBoolsGui(LogicComponent i2b, int x, int y, String[] args, boolean printInPortName, boolean printOutPortName) {
        super(i2b, x, y, args, printInPortName, printOutPortName);
        this.outPortPositions = new Point[i2b.getOutPins().length];
    }

    @Override
    public List<Drawable> getDrawables() {
        GuiPinLine line;
        LinkedList<Drawable> gui = new LinkedList<Drawable>();
        IntToBools i2b = (IntToBools)this.component;
        int inNum = 1;
        int outNum = i2b.getOutPins().length;
        int heihgt = (outNum + 1) * 15;
        int width = 20 + DrawUtils.stringWidth(i2b.getName(), 13, "Times New Roman", 0);
        GuiTextLabel label = new GuiTextLabel(this.x + 54, this.y + this.getYMargin(inNum) + heihgt / 2, i2b.getName(), 14);
        this.drawables.add(label);
        ArrayList<List<Point>> sections = new ArrayList<List<Point>>();
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(this.x + 39, this.y + this.getYMargin(inNum)));
        points.add(new Point(this.x + 55 + width, this.y + this.getYMargin(inNum)));
        points.add(new Point(this.x + 55 + width, this.y + this.getYMargin(inNum) + heihgt));
        points.add(new Point(this.x + 39, this.y + this.getYMargin(inNum) + heihgt));
        points.add(new Point(this.x + 39, this.y + this.getYMargin(inNum)));
        sections.add(points);
        this.drawables.add(new GuiLine(sections));
        int startI0 = this.getYMargin(inNum) + heihgt / 2 + inNum * 15 / 2;
        int i = 0;
        while (i < inNum) {
            sections = new ArrayList();
            points = new ArrayList();
            points.add(new Point(this.x - 50 + 82, this.y + startI0));
            points.add(new Point(this.x - 50 + 89, this.y + startI0));
            sections.add(points);
            line = new GuiPinLine(sections, i2b.getInPin(i));
            this.drawables.add(line);
            this.inPortPosition = new Point(this.x - 50 + 89, this.y + startI0);
            label = new GuiTextLabel(this.x - 50 + 94, this.y + startI0, "" + i, 10);
            this.drawables.add(label);
            label = new GuiTextLabel(this.x + 28, this.y + startI0, i2b.getInPins()[i].getName(), 13, 1);
            this.drawables.add(label);
            label = new GuiPinLabel(this.x, this.y + startI0 + 15, i2b.getInPins()[i]);
            this.drawables.add(label);
            startI0 -= 15;
            ++i;
        }
        startI0 = this.getYEnd(outNum) - 15;
        i = 0;
        while (i < outNum) {
            sections = new ArrayList();
            points = new ArrayList();
            points.add(new Point(this.x + 66 + width, this.y + startI0));
            points.add(new Point(this.x + 56 + width, this.y + startI0));
            sections.add(points);
            line = new GuiPinLine(sections, i2b.getOutPin(i));
            this.drawables.add(line);
            this.outPortPositions[i] = new Point(this.x + 66 + width, this.y + startI0);
            label = new GuiTextLabel(this.x + 40 + width, this.y + startI0 + 2, "" + i, 10);
            this.drawables.add(label);
            if (this.printOutPortName) {
                label = new GuiTextLabel(this.x + 68 + width, this.y + startI0 + 2, i2b.getOutPins()[i].getName(), 13);
                this.drawables.add(label);
            }
            startI0 -= 15;
            ++i;
        }
        gui.addAll(this.drawables);
        return gui;
    }

    @Override
    public int getWidth() {
        return 150 + DrawUtils.stringWidth(this.component.getName(), 13, "Times New Roman", 0);
    }

    @Override
    public int getHeight() {
        int max = this.component.getOutPins().length;
        if (max <= 8) {
            return 180;
        }
        return 180 * max / 8;
    }

    protected int getYMargin(int n) {
        if (n == 2) {
            return 46;
        }
        return 18;
    }

    protected int getYEnd(int n) {
        int result = this.getYMargin(n);
        return result += (n + 1) * 15;
    }

    @Override
    public Point getOutPortPosition(int index) {
        if (index >= 0 && index < this.outPortPositions.length) {
            return this.outPortPositions[index];
        }
        return null;
    }

    @Override
    public Point getInPortPosition(int index) {
        if (index == 0) {
            return this.inPortPosition;
        }
        return null;
    }
}

