/*
 * Decompiled with CFR 0.152.
 */
package gui.components;

import gui.Drawable;
import gui.components.DrawableComponent;
import java.awt.Graphics;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;
import logic.LogicComponent;

public abstract class DrawableComponentAbstract
implements DrawableComponent {
    LogicComponent component;
    int x;
    int y;
    String[] args;
    boolean printInPortName;
    boolean printOutPortName;
    List<Drawable> drawables;

    public DrawableComponentAbstract(LogicComponent component, int x, int y, String[] args, boolean printInPortName, boolean printOutPortName) {
        this.component = component;
        this.x = x;
        this.y = y;
        this.args = args;
        this.printInPortName = printInPortName;
        this.printOutPortName = printOutPortName;
        this.drawables = new LinkedList<Drawable>();
    }

    @Override
    public Point getCorner(int corner) {
        switch (corner) {
            case 0: {
                return new Point(this.x, this.y);
            }
            case 1: {
                return new Point(this.x + this.getWidth(), this.y);
            }
            case 2: {
                return new Point(this.x, this.y + this.getHeight());
            }
            case 3: {
                return new Point(this.x + this.getWidth(), this.y + this.getHeight());
            }
        }
        return null;
    }

    @Override
    public void draw(Graphics g) {
        for (Drawable drawable : this.drawables) {
            drawable.draw(g);
        }
    }

    @Override
    public void update() {
        for (Drawable drawable : this.drawables) {
            drawable.update();
        }
    }

    @Override
    public List<Drawable> getDrawables() {
        return this.drawables;
    }
}

