/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GuiTextLabel;
import java.awt.Color;
import java.awt.Graphics;
import logic.Pin;

public class GuiPinLabel
extends GuiTextLabel {
    protected Pin pin;

    public GuiPinLabel(int x, int y, Pin pin) {
        super(x, y, "", 0, 12, "Arial", 1, Color.BLACK, 0.0);
        this.pin = pin;
    }

    @Override
    public void draw(Graphics g) {
        this.update();
        if (!this.pin.isHighZ()) {
            super.draw(g);
        }
    }

    @Override
    public void update() {
        if (!this.pin.isHighZ()) {
            switch (this.pin.getNumOfLines()) {
                case 4: {
                    this.label = String.format("%01x", this.pin.getIntVal()).toUpperCase();
                    break;
                }
                case 8: {
                    this.label = String.format("%02x", this.pin.getIntVal()).toUpperCase();
                    break;
                }
                case 12: {
                    this.label = String.format("%03x", this.pin.getIntVal()).toUpperCase();
                    break;
                }
                case 16: {
                    this.label = String.format("%04x", this.pin.getIntVal()).toUpperCase();
                    break;
                }
                case 24: {
                    this.label = String.format("%06x", this.pin.getIntVal()).toUpperCase();
                    break;
                }
                case 32: {
                    this.label = String.format("%08x", this.pin.getIntVal()).toUpperCase();
                    break;
                }
                default: {
                    this.label = Integer.toHexString(this.pin.getIntVal());
                }
            }
        }
    }

    public Pin getPin() {
        return this.pin;
    }

    public void setPin(Pin pin) {
        this.pin = pin;
    }
}

