/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Drawable;
import java.awt.Dimension;
import java.awt.Point;
import java.util.LinkedList;
import java.util.List;

public class GuiComponent {
    private String filename;
    private List<Drawable> drawables;

    public GuiComponent(String filename) {
        this.filename = filename;
        this.drawables = new LinkedList<Drawable>();
    }

    public void addDrawable(Drawable drawable) {
        if (!this.drawables.contains(drawable)) {
            this.drawables.add(drawable);
        }
    }

    public void addDrawables(List<Drawable> drawables) {
        for (Drawable drawable : drawables) {
            if (this.drawables.contains(drawable)) continue;
            this.drawables.add(drawable);
        }
    }

    public List<Drawable> getDrawables() {
        return this.drawables;
    }

    public void setDrawables(List<Drawable> drawables) {
        this.drawables = drawables;
    }

    public String getFileName() {
        return this.filename;
    }

    public Dimension calcDimension() {
        Dimension result = new Dimension();
        int minX = 0;
        int maxX = Integer.MIN_VALUE;
        int minY = 0;
        int maxY = Integer.MIN_VALUE;
        for (Drawable drawable : this.drawables) {
            Point tl = drawable.getCorner(0);
            Point br = drawable.getCorner(3);
            if (minX > tl.x) {
                minX = tl.x;
            }
            if (minY > tl.y) {
                minY = tl.y;
            }
            if (maxX < br.x) {
                maxX = br.x;
            }
            if (maxY >= br.y) continue;
            maxY = br.y;
        }
        result.setSize(maxX - minX + 50, maxY - minY + 50);
        return result;
    }
}

