  import java.io.*;
  import java.util.*;
  /**      class BFSParser performs search for keywords and hyperlinks*/
  class BFSParser {
    static private boolean isEOF;                //end of file indicator
    static private boolean isTag;                        //tag indicator
  //--------------------------------------------------------------------
    static public void parsing(BFSURL u, DataInputStream dis,
                                              boolean staviK) {
      int c;
      String s;
      try {
        isEOF=false; 
        isTag=false;
        s=nextWord(dis);
        isKW(s,u);                                //s might be a keyword
        while (!isEOF) {
          if (isTag) {                                       //enter tag
            String buffer="";
            c=dis.read();
            if (c==92||c==33) do c=dis.read(); while (c!='>');
            else buffer+=(char)c;
            do { c=dis.read(); buffer+=(char)c; }
            while(c!='>');
            s=parseTag(u,buffer);
            if(s!="") {                                      //s is link
              if (s.startsWith("http://")) s=s.substring(7);
              if (s.endsWith("html")||s.endsWith("htm")||
                                      s.endsWith("asp")) {
                if(!u.linkovi.contains(s)) u.linkovi.addElement(s);
                if (staviK && !(BFS.ulaz.contains(s)||
                        BFS.kandJS.containsKey(s)|| BFS.kand.contains(s)
                     || BFS.izlaz.containsKey(s))) 
                  BFS.kand.addElement(s);  //add link to possible output
                }
            }
            isTag=false;
            s=nextWord(dis);
            isKW(s,u);                            //s might be a keyword
            if (isEOF) return;
          }
          if (!isTag && BFS.l!=0) {                         //plain text
            String [] niz = new String[BFS.maxKW];
            int max=0;
            niz[max]=s;
            max++;
            String fraza=s;                   //fraza might be a keyword
            while (max<BFS.maxKW && !isEOF && !isTag) {
              s=nextWord(dis);         //maxKW is maximum keyword length
              if (!s.equals("")) { 
                niz[max]=s; max++; fraza=fraza+" "+s; isKW(fraza,u);
              }
            }
            if (max<BFS.maxKW) {          //end of plain text is reached
              while(max>0) {       //search for keywords in recent words
                fraza="";
                for (int i=1; i<max; i++) {
                  niz[i-1]=niz[i]; 
                  if (fraza.equals("")) fraza=niz[i-1];
                  else fraza=fraza+" "+niz[i-1]; 
                  isKW(fraza,u);
                }   
                max--;
              }
            }
            else {                         //it is not end of plain text
              while (!isEOF && !isTag) {
                s=nextWord(dis);
                if (!s.equals("")) { 
                  fraza="";
                  for (int i=1; i<max; i++) {
                    niz[i-1]=niz[i];  
                    if (fraza.equals("")) fraza=niz[i-1];
                    else fraza=fraza+" "+niz[i-1]; 
                    isKW(fraza,u);
                  }
                  niz[max-1]=s; fraza=fraza+" "+s; isKW(fraza,u);
                }
              }
              while(max>0) {              //end of plain text is reached
                fraza="";
                for (int i=1; i<max; i++) {
                  niz[i-1]=niz[i]; 
                  if (fraza.equals("")) fraza=niz[i-1];
                  else fraza=fraza+" "+niz[i-1]; 
                  isKW(fraza,u);
                }   
                max--;
              }
            } 
          }
        }
      }
      catch(IOException ioe) {}
      catch(Exception e){System.out.println("Exception:"+e.toString());}
    }
  //--------------------------------------------------------------------
    static private String nextWord(DataInputStream dis) 
                 throws IOException {   //return next word from text, or
      int c=dis.read();        //"" when next word is end of file or tag
      String s="";
      if (c==-1) {isEOF=true; return s;}
      if (c=='<') {isTag=true; return s;}
      if (isSeparator(c)) {
        while (isSeparator(c)) c=dis.read();
        if (c==-1) {isEOF=true; return s;}
        if (c=='<') {isTag=true; return s;}
      }
      while (!isSeparator(c)) {
        if (c==-1) {isEOF=true; return s;}
        if (c=='<') {isTag=true; return s;}
        s+=(char)c;
        c=dis.read();
      } 
      return s.toLowerCase();
    }
  //--------------------------------------------------------------------
    static private boolean isSeparator(int c) {
      return (BFS.sep.indexOf((char)c)!=-1);   //-1 if c isn't separator
    }
  //--------------------------------------------------------------------
    static public boolean isKW(String s, BFSURL u) {
      int l;         //if s is keyword, increase keyword frequency for u
      s=s.toLowerCase();
      l=BFS.nizKW.indexOf(s);
      if (l!=-1) u.indeksi[l]++;
      return (l!=-1);
    }
  //--------------------------------------------------------------------
    static private String parseTag(BFSURL u, String is)throws IOException{
      int stLink, endLink;
      String s="";
      String[] keyword={"href","src","background","action"};
      if (is.toLowerCase().startsWith("meta")) {
        String kw="keywords";
        if (content(is.toLowerCase(),"name").equals(kw)||
            content(is.toLowerCase(),"http-equiv").equals(kw)) {
          String ts=content(is.toLowerCase(),"content");
          if (ts!="") { 
            parseKW(u,ts.toLowerCase());
            return s;                   //return after found keyword tag
          } 
        }
        String des="description";
        if (content(is.toLowerCase(),"name").equals(des)||
            content(is.toLowerCase(),"http-equiv").equals(des)) {
          String ts=content(is.toLowerCase(),"content");
          if (ts!="") { 
            parseDes(u,ts.toLowerCase());
            return s;               //return after found description tag
          } 
        }
      }
      if (!(is.toLowerCase().startsWith("area")||       //look for links
            is.toLowerCase().startsWith("img")||
            is.toLowerCase().startsWith("image")||
            is.toLowerCase().startsWith("body")||
            is.toLowerCase().startsWith("a")||
            is.toLowerCase().startsWith("frame")||
            is.toLowerCase().startsWith("form")||
            is.toLowerCase().startsWith("embed")))  return s;
      int i=0;
      int pos=-1;
      while (i<4 && (pos=is.toLowerCase().indexOf(keyword[i]))==-1) i++;
      if (pos==-1) return s;
      stLink=is.indexOf('=',pos)+1;
      while(Character.isSpace(is.charAt(stLink))) stLink=stLink+1;
      if(is.charAt(stLink)=='\"') {
        stLink=stLink+1;
        while(Character.isSpace(is.charAt(stLink))) stLink=stLink+1;
        endLink=is.indexOf('\"',stLink)-1;
        while(Character.isSpace(is.charAt(endLink))) endLink=endLink-1;
      }
      else {
        endLink=stLink;
        while(!(Character.isSpace(is.charAt(endLink+1)))&&
              !(is.charAt(endLink+1)=='>'))
          endLink=endLink+1;
      }
      if (stLink>=endLink) return s;
      s = parseLink(u,is.substring(stLink,endLink+1));
      return s;
    }
  //--------------------------------------------------------------------
    static private String parseLink(BFSURL u, String is) {
      StringBuffer temp=new StringBuffer(20);
      StringBuffer temp2=new StringBuffer(20);
      String s="";
      int level=0;
      int pos=0;
      int next;
      if(is.toLowerCase().startsWith("mailto")||
         is.toLowerCase().startsWith("ftp")||
         is.toLowerCase().startsWith("telnet")||
         is.toLowerCase().startsWith("file")||
         is.toLowerCase().startsWith("gopher"))
      return s;
      if (is.startsWith("http://")||is.startsWith("#")) return s;
      if (is.startsWith("../")) {
        while ((next=is.indexOf("../",pos))!=-1) { level++; pos=next+3; }
        temp.append(is.substring(pos));
        pos=u.getHttpName().length();
        for(int i=level+1;i>0;i--){
          next=u.getHttpName().lastIndexOf('/',pos);
          pos=next-1;
        }
        if (pos>0) temp2.append(u.getHttpName().substring(0,pos+1)+"/");
        temp2.append(temp.toString());
        if (temp2.toString().indexOf('#')!=-1)
          s=temp2.toString().substring(0,temp2.toString().indexOf('#'));
        else s=temp2.toString();
        return s;
      }
      else {
        temp.append(u.getHttpName().substring(0,
                    u.getHttpName().lastIndexOf('/')+1));
        temp.append(is);
        if (temp.toString().indexOf('#')!=-1)
          s=temp.toString().substring(0,temp.toString().indexOf('#'));
        else s=temp.toString();
	return s;
      }
    }
  //--------------------------------------------------------------------
    static private String content(String is, String ime) {
      int pos, stName, endName;  //content of keyword or description tag
      String s="";
      pos=is.indexOf(ime);
      if (pos!=-1) {
        stName=is.indexOf('=',pos)+1;
        while (Character.isSpace(is.charAt(stName))) stName++;
        if(is.charAt(stName)=='\"') {
          stName++;
          endName=is.indexOf('\"',stName);
          s=is.substring(stName, endName).trim();
        }
        return s;
      }
      return s;
    }
  //--------------------------------------------------------------------
    static private void parseKW(BFSURL u, String is) {
      String s;                                     // look for keywords
      StringBuffer sb=new StringBuffer(100);
      int i=0;
      boolean pjs=true;
      boolean kraj=false;
      char c;
      kraj = (is.length()==i);
      while (!kraj) {
        while (is.length()!=i && is.charAt(i)!=',') {
          c=is.charAt(i);
          if (isSeparator((int)c)) {
            if (!pjs) { pjs=true; sb.append(' '); }  
          }
          else { pjs=false; sb.append(c); }
          i++;
        }
        s=sb.toString().trim(); isKW(s,u);         //s might be in nizKW
        kraj = (is.length()==i);
        i++; pjs=true; sb=new StringBuffer(100);
      }
      return;
    }
  //--------------------------------------------------------------------
    static private void parseDes(BFSURL u, String is) {
      int n=0;
      StringTokenizer st=new StringTokenizer(is,BFS.sep,true);
      String[] niz = new String[st.countTokens()];
      String temp = "";
      while (st.hasMoreTokens()) {
        temp=st.nextToken();       //niz is array of description content
        if (!isSeparator((int)temp.charAt(0))) { niz[n]=temp; n++; }
      }
      int poc=0;
      while (poc<n) {
        String fraza=niz[poc]; isKW(fraza,u);
        for (int i=poc+1; i<poc+BFS.maxKW; i++) 
          if (i<n) {
            fraza=fraza+" "+niz[i];   //look for keywords in description
            isKW(fraza,u);
          }
        poc++;
      }
    }
  }
