

//Klasa za pristup bazi urltable
import java.awt.*;
import java.util.*;
import java.sql.*;
class Baza{
	private Connection veza;
	private PreparedStatement ubaci;
	private static PreparedStatement citaj;
	private PreparedStatement selektujTopike;
	private PreparedStatement proveriZapis;
	private PreparedStatement brisiTopic;
	private PreparedStatement brisiUrl;



		//Baza konstruktor:pravi SQL upite za kasniju upotrebu
		public Baza(String baza,String korisnik,String lozinka){
		try{
			Class.forName ("sun.jdbc.odbc.JdbcOdbcDriver");
				}catch(ClassNotFoundException g){System.exit(1);} 
					// Make the connection object.
				try{
				   veza = DriverManager.getConnection(baza,korisnik,lozinka);
				}catch(SQLException e){
				   System.out.println("*** Neuspesno otvaranje baze ***");
				   System.exit(2);
				}
		try{
				   ubaci=veza.prepareStatement("INSERT INTO urltable VALUES(?,?);");
				   citaj=veza.prepareStatement("SELECT URL FROM urltable WHERE Topic =?;");
				   selektujTopike=veza.prepareStatement("SELECT DISTINCT Topic FROM urltable;");
				   proveriZapis=veza.prepareStatement("SELECT * FROM urltable WHERE Topic=? and URL=?;");
				   brisiTopic=veza.prepareStatement("DELETE * FROM urltable WHERE Topic= ?;");
				   brisiUrl=veza.prepareStatement("DELETE * FROM urltable WHERE Topic= ? and URL=?;");
				}catch (SQLException e){
				  System.out.println("Neuspesna inicijalizacija upita");
			}
	}
	//Metod za selektovanje url-ova za zati topic
		public static String[] citaj(String Topic) throws SQLException{
				int i=0;
				ResultSet rs;
				String ceoUrl;
				String[] rezultat= new String[500];
				citaj.setString(1,Topic);
				rs=citaj.executeQuery();
				while(rs.next()){
						ceoUrl=rs.getString(1);
						rezultat[i++]=ceoUrl.substring(0,ceoUrl.indexOf("#http://"));
					}	
				rs.close();
				return rezultat;
	}
		//Metod za brisanje svih zapisa sa zadatim topikom
		public void obrisi(String Topic)throws SQLException{
				if(!usluge.prazanString(Topic)){
					brisiTopic.setString(1,Topic);
					brisiTopic.executeUpdate();
				}	
		}
		//Metod za brisanje zapisa sa zadatim url-om i topikom
		public void obrisi(String Topic,String[] Url) throws SQLException{
				brisiUrl.setString(1,Topic);
				for(int i=0;i<Url.length;i++){
					Url[i]=new String(Url[i]+"#http://"+Url[i]+"#");
					brisiUrl.setString(2,Url[i]);
					brisiUrl.executeUpdate();
				}	
		}
		//Metod za ispitivanje da li postoji zapis
		private boolean postojiZapis(String Topic,String Url) throws SQLException{
				ResultSet rs;
				proveriZapis.setString(1,Topic);
				proveriZapis.setString(2,Url);
				rs=proveriZapis.executeQuery();
				boolean b= rs.next();
				rs.close();
				return b;
		}
		//Metod za selektovanje svih topika
		public String[] selektujTopike()throws SQLException{
				int i=0;
				String[] rezultat= new String[100];
				ResultSet rs;
				rs=selektujTopike.executeQuery();
				while(rs.next()){
					rezultat[i++]=rs.getString(1);}
				return rezultat;
		}
		//Metod za kreiranje novog zapisa u bazi urltable
		public int ubaci(String Topic,String[] Url) throws SQLException {
			if(!usluge.prazanString(Topic)){
				int upisanihUBazu=0;
				Topic=new String(usluge.ocistiString(Topic));
				ubaci.setString(1,Topic);
				for(int i=0;i<Url.length;i++){
					if(!usluge.prazanString(Url[i])){
						Url[i]=new String(Url[i]+"#http://"+Url[i]+"#");
						ubaci.setString(2,Url[i]);
						if(!postojiZapis(Topic,Url[i])){
							ubaci.execute();
							upisanihUBazu++;}
					}	
				}	
				return upisanihUBazu;
			}
			else return 0;	
	}
/**
 * This method was created by a SmartGuide.
 * @return int
 * @param Topic java.lang.String
 * @param Url java.lang.String
 */
public void ubaci(String Topic,String Url,Label status)throws SQLException {
				int upisanihUBazu=0;
				if(!usluge.prazanString(Topic) & !usluge.prazanString(Url)){
					Url=new String(Url+"#http://"+Url+"#");
					Topic=new String(usluge.ocistiString(Topic));
					ubaci.setString(1,Topic);
					ubaci.setString(2,Url);
					if(!postojiZapis(Topic,Url)) {
						ubaci.execute();
						upisanihUBazu++;
						status.setText("Updated 1 row in the Database");}
					else{
						status.setText("Url allready exists");
						}
				}
				else{
					status.setText("Uncorrect data-Updated 0 rows in the database");
				}			
				return ;
}
}