  import java.io.*;
  import java.util.*;
  /**  class agent is executable, performs Best First Search algorithm*/
  class agent {
  //--------------------------------------------------------------------
    static public void main(String[] args) throws IOException {
      Linker[] linker;                          //variables for "Spider"
      Queue queue;
      int nOfLinkers=3;
      int depth=2;
      boolean pics=false;
      PrintStream ps=new PrintStream(new FileOutputStream("greske"));
      System.setErr(ps);                                  //error stream
      int brojIzlaza=10;                    //number of output documents
      boolean coms=false;                              //comments are on
      boolean slikeSet=false;                   //enable picture loading
      boolean izlazSet=false;        //change number of output documents
      boolean comsSet=false;                           //enable comments
      boolean keySet=false;                  //load keywords from a file
      boolean josSet=false;     //load input documents' URLs from a file
      String fajl;                                 //temporary file name
      if (args.length==0) { printHelp(); return; }    //check user input
      try {
        BFS.coms=false;
        for(int i=0; i<args.length; i++)
          if(args[i].toLowerCase().startsWith("-d")) {
            if (izlazSet) { printHelp(); return; }
            brojIzlaza=Integer.parseInt(args[i].substring(2));
            if (brojIzlaza<=0) { printHelp(); return; }
            izlazSet=true;
          }
          else if (args[i].toLowerCase().startsWith("-p")) {
            if (slikeSet) { printHelp(); return; }
            pics=true; slikeSet=true;
          }
          else if(args[i].toLowerCase().startsWith("-u")) {
            if (josSet) { printHelp(); return; }
            josSet=true;
          }
          else if (args[i].toLowerCase().startsWith("-c")) {
            if (comsSet) { printHelp(); return; }
            BFS.coms=true; comsSet=true;
          }
          else if (args[i].toLowerCase().startsWith("-k")) {
            if (keySet) { printHelp(); return; }
            keySet=true;
          }
          else if (args[i].startsWith("-")) {
            printHelp(); return;
          }
          else {                  //valid URL will be added to input set
            String s=makeURL(args[i]);
            if(!BFS.ulaz.contains(s)) BFS.ulaz.addElement(s);
          }
        if (josSet) {                 //load input documents from a file
          int c;
          fajl="";
          System.out.print("\nName of file with URLs=");
          while((c=System.in.read()) != 13) {
            if (c!=13 && c!=10) fajl+=(char)c;
          }
          System.out.println();
          DataInputStream dis;
          dis = new DataInputStream(new FileInputStream(fajl));
          String s="";
          while ((c=dis.read())!=-1) {
            if (!Character.isSpace((char)c)) s+=(char)c;
            else if (s!="") {
              s=makeURL(s.toLowerCase());
              if(!BFS.ulaz.contains(s)) BFS.ulaz.addElement(s);
              s="";
            }
          }
          if (s!="") {
            s=makeURL(s.toLowerCase());
            if(!BFS.ulaz.contains(s)) BFS.ulaz.addElement(s);
            s="";
          }
          dis.close();
        }
        if(BFS.ulaz.size()==0) { 
          printHelp();
          return;    //program ends if number of input documents is zero
        }
        if (keySet) {                        //load keywords from a file
          int c;
          fajl="";
          System.out.print("\nName of file with keywords=");
          while((c=System.in.read()) != 13) {
            if (c!=13 && c!=10) fajl+=(char)c;
          }
          System.out.println();
          BFS.initFileParsing(fajl.trim());
        }
        BFS.print(BFS.ulaz,"Input");          //print program parameters
        if (BFS.coms) {
          System.out.println("Number of output documents = "+brojIzlaza);
          if (pics) System.out.println("With pictures");
          else System.out.println("Without pictures");
          System.out.println();
        }
        BFS.initUlazN();  //creating an array suitable for BFS algorithm
        queue=new Queue(nOfLinkers,pics);     //begin "Spider" execution
        MyURL.queue = queue;
        linker=new Linker[nOfLinkers];
        initLinker(linker,queue);
        for (int i=0; i<BFS.n; i++) {
          String u=(String)BFS.ulaz.elementAt(i);
          if (BFS.coms) System.out.println("Queueing:"+"http://"+u);
          queue.putURL(new MyURL("http://"+u,depth));
        }
        runLinker(linker,queue);                //end "Spider" execution
        BFS.initKeyParsing();     //look for keywords in input documents
        BFS.initL();                       //number of keywords is BFS.l
        if (BFS.l==0) {
          System.out.println("Input documents have no keyword tag!");
          return;
        }
        if (BFS.coms) BFS.print(BFS.nizKW,"Keywords");  //print keywords
        BFS.initBFSParsingUlazN();    //look for hyperlinks and keywords
                                      //in input documents
        if (BFS.coms)                           //print possible outputs
          BFS.print(BFS.kand,"Input hyperlinks");
        BFS.initA2();    //compute an array which helps in JS evaluation
        boolean kraj = (BFS.kand.size() == 0);
        while (!kraj) {      //if there are possible outputs search them
          BFS.initKandN();
          BFS.kand.removeAllElements();
          BFS.initBFSParsingKandN();  //look for hyperlinks and keywords
                                      //in possible outputs
          if (BFS.coms) {
            System.out.println();
            BFS.print(BFS.kandJS,"Option");
          }
                   //look for the best possible output (with highest JS)
          String key = BFS.maxEl(BFS.kandJS);
          String el = (String)BFS.kandJS.get(key);
          BFS.izlaz.put(key,el);      //the best candidate is now output
          BFS.kandJS.remove(key);     //and is no longer candidate
          if (BFS.coms) System.out.println("Next node="+key+"\n");
          //if there is no enough output documents, continue with search
          if (BFS.izlaz.size()<brojIzlaza) {
            queue=new Queue(nOfLinkers,pics); //begin "Spider" execution
            MyURL.queue = queue;
            linker=new Linker[nOfLinkers];
            initLinker(linker,queue);
            String t = "http://"+makeURL(key);
            if (BFS.coms) System.out.println("Queueing: "+t+"\n");
            queue.putURL(new MyURL(t,depth));
            runLinker(linker,queue);            //end "Spider" execution
            BFSURL tempK = new BFSURL(key);//   links of the best option
            tempK.initIndeksi();           //...are new possible outputs
            BFS.initBFSParsing(tempK,true);
            if (BFS.coms) {                 //print new possible outputs
              BFS.print(BFS.kand,"Key hyperlinks");
              System.out.println();
            }
          }
          kraj = (BFS.kand.size()==0 || BFS.izlaz.size()==brojIzlaza);
        }
                   //if number of output documents is less than required
                   //and if number of possible outputs is zero,
                   //transfer best option documents to output
        if (BFS.izlaz.size() != brojIzlaza) {
          kraj=false;
          while(!kraj) {
            if (BFS.kandJS.size()==0) { kraj = true; }
            else {
              String key = BFS.maxEl(BFS.kandJS);
              String el = (String)BFS.kandJS.get(key);
              BFS.izlaz.put(key,el);
              BFS.kandJS.remove(key);
              if (BFS.izlaz.size()==brojIzlaza) kraj = true;
            }
          }
        }
        System.out.println("Result of Agent search:");
        System.out.println("-----------------------");
        BFS.print(BFS.izlaz,"Output");          //print output documents
      }
      catch (Exception ie) {System.out.println("Error:"+ie.toString());}
    }
  //--------------------------------------------------------------------
    static private void initLinker(Linker[] linker, Queue queue) {
      for (int i=0;i<linker.length;i++)              //from MyURL.main()
        linker[i]=new Linker(String.valueOf(i),queue);
    }
  //--------------------------------------------------------------------
    static private void runLinker(Linker[] linker, Queue queue) 
                                  throws Exception { //from MyURL.main()
      for (int i=0;i<linker.length;i++) linker[i].start();
      boolean over=false;
      while (!over) {
        Thread.sleep(5000);
        over=true;
        for (int i=0;i<linker.length;i++)
        over=(queue.table.elementAt(i)==null) && over;
      }
      for (int i=0;i<linker.length;i++) linker[i].stop();
    }
  //--------------------------------------------------------------------
    static private String makeURL(String s) {
      s = s.toLowerCase();                              //make valid URL
      if (s.startsWith("http://")) s=s.substring(7);
      if (s.indexOf('/')==-1) s=s+"/index.html";
      if (s.endsWith("/")) s=s+"index.html";
      if (s.lastIndexOf(".")<s.lastIndexOf("/")) s=s+"/index.html";
      return s;
    }
  //--------------------------------------------------------------------
    static private void printHelp() {
      String line;                  //program parameters are not correct
      try {
        FileInputStream fis=new FileInputStream("ReadMe.txt");
        DataInputStream dis=new DataInputStream(fis);
        System.out.println();
        while((line=dis.readLine())!=null) System.out.println(line);
      }
      catch(FileNotFoundException fnfe) {
        System.out.println("FileNotFound exception");
        return;
      }
      catch(IOException ioe) { }
    }
  }
