  import java.io.*;
  /**  class KeyParser extracts keywords from a set of input documents*/
  class KeyParser {
  //--------------------------------------------------------------------
    static public void parsing(BFSURL u, DataInputStream dis) {
      int c;                      //look for keywords in input documents
      String s;
      try {
        while ((c=dis.read())!=-1) {
          if (c=='<') {
            String buffer="";
            c=dis.read();
            if (c==92||c==33) continue; else buffer+=(char)c;
            do { c=dis.read(); buffer+=(char)c; } 
            while(c!='>');
            boolean isKW = parseTag(buffer);
            if (isKW) return;           //after found keyword tag return
          } 
        }
      }
      catch(IOException ioe) {}
      catch(Exception e){System.out.println("Exception: "+e.toString());}
    }
  //--------------------------------------------------------------------
    static public void parsingFile(DataInputStream dis) {
      int c;                                 //load keywords from a file
      String fraza="";
      boolean prazno=true;
      try {
        while ((c=dis.read())!=-1) {
          if (c==',') {              //separator between keywords is ','
            fraza=fraza.toLowerCase().trim();
            if (fraza!="" && !BFS.nizKW.contains(fraza)) {
              BFS.nizKW.addElement(fraza);
              fraza=""; prazno=true;
            }
          }
          else {
            if (!prazno && isSeparator((char)c)) {
              fraza+=' '; prazno=true;
            }
            if (!isSeparator((char)c)) {
              fraza+=(char)c; if (prazno) prazno=false;
            }
          }
        }
        fraza=fraza.toLowerCase().trim();
        if (fraza!="" && !BFS.nizKW.contains(fraza)) {
          BFS.nizKW.addElement(fraza);            //fraza is new keyword
        }
      }
      catch(IOException ioe) {}
      catch(Exception e){System.out.println("Exception: "+e.toString());}
    }
  //--------------------------------------------------------------------
    static private boolean parseTag(String is)throws IOException {
      is=is.toLowerCase();          //returns true if tag is keyword tag
      String kw="keywords";
      boolean isKW=false;
      if (is.startsWith("meta")) {
        if (content(is,"name").equals(kw)||
            content(is,"http-equiv").equals(kw)) {
          is=content(is,"content");
          if (is!="") { parseKW(is); isKW=true; }
        }
      }  
      return isKW;
    }
  //--------------------------------------------------------------------
    static private String content(String is, String ime) {
      int pos, stName, endName;                 //content of keyword tag
      String s="";
      pos=is.indexOf(ime);
      if (pos!=-1) {
        stName=is.indexOf('=',pos)+1;
        while (Character.isSpace(is.charAt(stName))) stName++;
        if(is.charAt(stName)=='\"') {
          stName++;
          endName=is.indexOf('\"',stName);
          s=is.substring(stName, endName).trim();
        }
        return s;
      }
      return s;
    }
  //--------------------------------------------------------------------
    static private void parseKW(String is) {
      String s;                                      //look for keywords
      StringBuffer sb=new StringBuffer(100);
      int i=0;
      boolean pjs=true;
      boolean kraj=false;
      char c; 
      kraj = (is.length()==i);
      while (!kraj) {
        while (is.length()!=i && is.charAt(i)!=',') {
          c=is.charAt(i);
          if (isSeparator(c)) { 
            if (!pjs) { pjs=true; sb.append(' '); }
          }
          else { pjs=false; sb.append(c); }
          i++;
        }
        s=sb.toString().trim(); 
        if (!BFS.nizKW.contains(s)) 
          BFS.nizKW.addElement(s);                    //s is new keyword
        kraj = (is.length()==i);
        i++; pjs=true; sb=new StringBuffer(100); 
      } 
      return;
    }
  //--------------------------------------------------------------------
    static private boolean isSeparator(char c) {
      return (BFS.sep.indexOf((char)c)!=-1);   //-1 if c isn't separator
    }
  }
