	#!/usr/bin/perl
	#
	# Sample connection oriented server using Perl
	#
	
	#define constants
	$all_free = 16000000000;		#cache size
	$lru_free = $all_free;	#lru cache size
	$lrumin_free = $all_free;	#lru cache size
	$elapsed_time = 0;	#simulation time

   	#open log file
	open(LOG, "+<rezultati_lru.txt") || die "$0: rezultati.txt will not open.";
	seek(LOG, 0,2);


	#process all files in directory with extension ".new"
	foreach $file (<*.new>) {
       	open(TRACES, "+<$file") || die "$file will not open.";
		print "\nOpened: ". $file. "\n";
		seek(TRACES, 0,2); $file_size = tell(TRACES); seek(TRACES, 0,0); 
		
		$pos = tell(TRACES);
		$prev_pos = tell(TRACES);
		$start_time = time();
		while(<TRACES>) { # takes data from $file
			print "\rdone: ".(tell(TRACES)/$file_size)." of 1     ";
			#if((tell(TRACES)/$file_size)>0.25){last;}
			@list = split(" ", $_);
			if($list[13]){
				&lru;
				#&lrumin;
			}
		}
		$end_time = time();
		close(TRACES);
		$elapsed_time += ($end_time-$start_time);
    }
	print "\nClosed: ". $s."\n";
	&std_stat;
	&log_stat;


sub std_stat{
		print "Size = $all_free bytes, elapsed $elapsed_time seconds	atp refresh=$atp_refresh\n";
		if($lru_access){print	"LRU     : Acc = $lru_access, Hits = $lru_hits (".($lru_hits/$lru_access*100)."%), Miss = $lru_miss \n".
								"		   WAcc = $lru_waccess, Hits = $lru_whits (".($lru_whits/$lru_waccess*100)."%), WMiss = $lru_wmiss \n";}
		if($lrumin_access){print	"LRUMIN     : Acc = $lrumin_access, Hits = $lrumin_hits (".($lrumin_hits/$lrumin_access*100)."%), Miss = $lrumin_miss \n".
								"		   WAcc = $lrumin_waccess, Hits = $lrumin_whits (".($lrumin_whits/$lrumin_waccess*100)."%), WMiss = $lrumin_wmiss \n";}
}
sub log_stat{
		print LOG "Size = $all_free, elapsed $elapsed_time seconds	atp refresh=$atp_refresh\n";
		if($lru_access){print LOG "LRU     : Acc = $lru_access, Hits = $lru_hits (".($lru_hits/$lru_access*100)."%), Miss = $lru_miss \n".
										"WAcc = $lru_waccess, Hits = $lru_whits (".($lru_whits/$lru_waccess*100)."%), WMiss = $lru_wmiss \n";}
		if($lrumin_access){print LOG	"LRUMIN     : Acc = $lrumin_access, Hits = $lrumin_hits (".($lrumin_hits/$lrumin_access*100)."%), Miss = $lrumin_miss \n".
								"		   WAcc = $lrumin_waccess, Hits = $lrumin_whits (".($lrumin_whits/$lrumin_waccess*100)."%), WMiss = $lrumin_wmiss \n";}
}
#############################################
# algorythms
#############################################


#########
# L R U #
#########
	
	sub lru{
		local($i);
		if($all_free*0.1 < $list[5]){
			$lru_miss++;
			$lru_wmiss += $list[5];
			$lru_access++;
			$lru_waccess+=$list[5];
			return 0;
		}elsif(defined $lru_cache{$list[7]}){
			#found in the cache
			$lru_hits++;
			$lru_whits += $list[5];
			for($i=0; $sorted_access[$i] ne $list[7]; $i++){}
			splice(@sorted_access, $i, 1);	
		}else{
			#not found in the cache
			$lru_miss++;
			$lru_wmiss += $list[5];
			
			# if there is no free space in the cache...
			while($lru_free < $list[5]){
				#...free some space

				$lru_free += $lru_size_cache{$sorted_access[0]};
				delete($lru_cache{$sorted_access[0]});
				delete($lru_size_cache{$sorted_access[0]});
				shift(@sorted_access);
			}
			
			#now there is free space in cache
			#reserve some space
			$lru_free -= $list[5];
		}
		
		#update cache for all cases
		#add to the tail of the list
		push(@sorted_access, $list[7]);
		$lru_cache{$list[7]} = $list[0];	#new last access time
		$lru_size_cache{$list[7]} = $list[5];	#new size
		$lru_access++;
		$lru_waccess+=$list[5];
	}

###############
# L R U M I N #
###############
	
	sub lrumin{
		my($i, $size);
		if($all_free*0.1 < $list[5]){
			$lrumin_miss++;
			$lrumin_wmiss += $list[5];
			$lrumin_access++;
			$lrumin_waccess+=$list[5];
			return 0;
		}elsif(defined $lrumin_cache{$list[7]}){
			#found in the cache
			$lrumin_hits++;
			$lrumin_whits += $list[5];
			for($i=0; $sorted_access[$i] ne $list[7]; $i++){}
			splice(@sorted_access, $i, 1);	
		}else{
			#not found in the cache
			$lrumin_miss++;
			$lrumin_wmiss += $list[5];
			
			# if there is no free space in the cache...
			for($i=0, $scalsize=2*$list[5]; $lrumin_free < $list[5]; $i++, $i%=(scalar @sorted_access)){
				if($i==0){$scalsize/=2;}
				#...free some space
				$size = $lrumin_size_cache{$sorted_access[$i]};
				if($size>=$scalsize){
					$lrumin_free += $size;
					delete($lrumin_cache{$sorted_access[$i]});
					delete($lrumin_size_cache{$sorted_access[$i]});
					splice(@sorted_access, $i, 1);
				}
			}
			
			#now there is free space in cache
			#reserve some space
			$lrumin_free -= $list[5];
		}
		
		#update cache for all cases
		#add to the tail of the list
		push(@sorted_access, $list[7]);
		$lrumin_cache{$list[7]} = $list[0];	#new last access time
		$lrumin_size_cache{$list[7]} = $list[5];	#new size
		$lrumin_access++;
		$lrumin_waccess+=$list[5];
	}


